% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_sig_cancer_type_index.R
\name{get_sig_cancer_type_index}
\alias{get_sig_cancer_type_index}
\title{Obtain Signature Index for Cancer Types}
\usage{
get_sig_cancer_type_index(
  sig_type = c("legacy", "SBS", "DBS", "ID"),
  seq_type = c("WGS", "WES"),
  source = c("PCAWG", "TCGA", "nonPCAWG"),
  keyword = NULL
)
}
\arguments{
\item{sig_type}{signature type.}

\item{seq_type}{sequencing type.}

\item{source}{data source.}

\item{keyword}{keyword to search in the signature index database.}
}
\value{
a \code{list}.
}
\description{
Obtain Signature Index for Cancer Types
}
\examples{
l1 <- get_sig_cancer_type_index()
l2 <- get_sig_cancer_type_index(sig_type = "SBS")
l3 <- get_sig_cancer_type_index(sig_type = "DBS", source = "PCAWG", seq_type = "WGS")
l4 <- get_sig_cancer_type_index(sig_type = "ID")
l5 <- get_sig_cancer_type_index(keyword = "breast")
l1
l2
l3
l4
l5
}
