% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_sig_profile_heatmap.R
\name{show_sig_profile_heatmap}
\alias{show_sig_profile_heatmap}
\title{Show Signature Profile with Heatmap}
\usage{
show_sig_profile_heatmap(
  Signature,
  mode = c("SBS", "DBS"),
  normalize = c("row", "column", "raw"),
  filters = NULL,
  x_lab = NULL,
  y_lab = NULL,
  legend_name = "auto",
  palette = "red",
  x_label_angle = 90,
  x_label_vjust = 1,
  x_label_hjust = 0.5,
  y_label_angle = 0,
  y_label_vjust = 0.5,
  y_label_hjust = 1,
  flip_xy = FALSE,
  sig_names = NULL,
  sig_orders = NULL,
  check_sig_names = TRUE
)
}
\arguments{
\item{Signature}{a \code{Signature} object obtained either from \link{sig_extract} or \link{sig_auto_extract},
or just a raw signature matrix with row representing components (motifs) and column
representing signatures (column names must start with 'Sig').}

\item{mode}{one of "SBS" and "DBS".}

\item{normalize}{one of 'row', 'column', 'raw' and "feature", for row normalization (signature),
column normalization (component), raw data, row normalization by feature, respectively.
Of note, 'feature' only works when the mode is 'copynumber'.}

\item{filters}{a pattern used to select components to plot.}

\item{x_lab}{x label.}

\item{y_lab}{y label.}

\item{legend_name}{name of figure legend.}

\item{palette}{color for value.}

\item{x_label_angle}{angle for x axis text.}

\item{x_label_vjust}{vjust for x axis text.}

\item{x_label_hjust}{hjust for x axis text.}

\item{y_label_angle}{angle for y axis text.}

\item{y_label_vjust}{vjust for y axis text.}

\item{y_label_hjust}{hjust for y axis text.}

\item{flip_xy}{if \code{TRUE}, flip x axis and y axis.}

\item{sig_names}{set name of signatures, can be a character vector.
Default is \code{NULL}, prefix 'Sig' plus number is used.}

\item{sig_orders}{set order of signatures, can be a character vector.
Default is \code{NULL}, the signatures are ordered by alphabetical order.
If an integer vector set, only specified signatures are plotted.}

\item{check_sig_names}{if \code{TRUE}, check signature names when input is
a matrix, i.e., all signatures (colnames) must start with 'Sig'.}
}
\value{
a \code{ggplot} object.
}
\description{
This is a complementary function to \code{\link[=show_sig_profile]{show_sig_profile()}}, it is used for visualizing
some big signatures, i.e. SBS-1536, not all signatures are supported. See details for
current supported signatures.
}
\details{
Support:
\itemize{
\item SBS-24
\item SBS-96
\item SBS-384
\item SBS-1536
\item SBS-6144
\item DBS-78
\item DBS-186
}
}
\examples{
# Load SBS signature
load(system.file("extdata", "toy_mutational_signature.RData",
  package = "sigminer", mustWork = TRUE
))
# Show signature profile
p1 <- show_sig_profile_heatmap(sig2, mode = "SBS")
p1
}
