% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_sig_exposure.R
\name{get_sig_exposure}
\alias{get_sig_exposure}
\title{Get Signature Exposure from 'Signature' Object}
\usage{
get_sig_exposure(
  Signature,
  type = c("absolute", "relative"),
  rel_threshold = 0.01
)
}
\arguments{
\item{Signature}{a \code{Signature} object obtained either from \link{sig_extract} or \link{sig_auto_extract},
or just a raw exposure matrix with column representing samples (patients) and row
representing signatures.}

\item{type}{'absolute' for signature exposure and 'relative' for signature relative exposure.}

\item{rel_threshold}{used when type is 'relative', relative exposure less
than this value will be set to 0 and the remaining signature exposure will be scaled
to make sum as 1 accordingly. Of note, this is a little different from the
same parameter in \link{sig_fit}.}
}
\value{
a \code{data.table}
}
\description{
Get Signature Exposure from 'Signature' Object
}
\examples{
# Load mutational signature
load(system.file("extdata", "toy_mutational_signature.RData",
  package = "sigminer", mustWork = TRUE
))
# Get signature exposure
expo1 <- get_sig_exposure(sig2)
expo1
expo2 <- get_sig_exposure(sig2, type = "relative")
expo2
}
\author{
Shixiang Wang \href{mailto:w_shixiang@163.com}{w_shixiang@163.com}
}
