% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buttons.R
\name{sg_button}
\alias{sg_button}
\title{Buttons}
\usage{
sg_button(sg, label, event, class = "btn btn-default")
}
\arguments{
\item{sg}{An object of class \code{sigmajs}as intatiated by \code{\link{sigmajs}}.}

\item{label}{Button label.}

\item{event}{Event the button triggers, see valid events.}

\item{class}{Button \code{CSS} class, see note.}
}
\description{
Add buttons to your graph.
}
\details{
You can pass multiple events as a vector, see examples.
}
\note{
The default class (\code{btn btn-default}) works with Bootstrap 3 (the default framework for Shiny and R markdown).
}
\section{Events}{

\itemize{
  \item{\code{force_start}}
  \item{\code{force_stop}}
  \item{\code{noverlap}}
  \item{\code{drag_nodes}}
  \item{\code{relative_size}}
  \item{\code{add_nodes}}
  \item{\code{add_edges}}
  \item{\code{drop_nodes}}
  \item{\code{drop_edges}}
  \item{\code{animate}}
  \item{\code{export_svg}}
  \item{\code{export_img}}
}
}

\examples{
nodes <- sg_make_nodes() 
edges <- sg_make_edges(nodes)

# Button starts the layout and stops it after 3 seconds
sigmajs() \%>\% 
  sg_nodes(nodes, id, size) \%>\% 
  sg_edges(edges, id, source, target) \%>\% 
  sg_force_start() \%>\% 
  sg_force_stop(3000) \%>\% 
  sg_button("start layout", c("force_start", "force_stop"))
  
# additional nodes
nodes2 <- sg_make_nodes()
nodes2$id <- as.character(seq(11, 20))

# add delay
nodes2$delay <- runif(nrow(nodes2), 500, 1000)

sigmajs() \%>\%
  sg_nodes(nodes, id, label, size, color) \%>\%
  sg_add_nodes(nodes2, delay, id, label, size, color) \%>\% 
  sg_button("add nodes", "add_nodes")

}
