% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/categorize.R
\name{categorize_nosignal}
\alias{categorize_nosignal}
\title{Checks for signal in the data.}
\usage{
categorize_nosignal(parameterVectorLinear,
  threshold_line_slope_parameter = 0.01, threshold_intensity_interval = 0.1,
  threshold_minimum_for_intensity_maximum = 0.3)
}
\arguments{
\item{parameterVectorLinear}{is the output of lineFitFunction.}

\item{threshold_line_slope_parameter}{minimum for line slope (Default is 0.01).}

\item{threshold_intensity_interval}{minimum for intensity range (Default is 0.1).}

\item{threshold_minimum_for_intensity_maximum}{minimum allowed value for intensity maximum}
}
\value{
Function returns one of two text outputs "no_signal" or "NOT no_signal".
}
\description{
Checks if signal is present in the data. Often a high percentage of high through-put data does not contain a signal. Checking if data does not contain signal before doing a sigmoidal or double sigmoidal fit can make analysis of data from high through-put experiments much faster.
}
\examples{
# Example 1 with double sigmoidal data

time=seq(3,24,0.1)

#simulate intensity data and add noise
noise_parameter=0.2
intensity_noise=runif(n = length(time),min = 0,max = 1)*noise_parameter
intensity=doublesigmoidalFitFormula(time,
                                   finalAsymptoteIntensity=.3,
                                   maximum=4,
                                   slope1=1,
                                   midPoint1=7,
                                   slope2=1,
                                   midPointDistance=8)
intensity=intensity+intensity_noise

dataInput=data.frame(intensity=intensity,time=time)
normalizedInput = normalizeData(dataInput,dataInputName="batch_01_21_2016_samp007623")


# Fit linear model
linearModel=fitFunction(dataInput=normalizedInput,
                                 model="linear",
                                 n_runs_min=20,
                                 n_runs_max=500,
                                 showDetails=FALSE)

isThis_nosignal=categorize_nosignal(parameterVectorLinear=linearModel)



# Example 2 with no_signal data

time=seq(3,24,0.1)

#simulate intensity data and add noise
noise_parameter=0.05
intensity_noise=runif(n = length(time),min = 0,max = 1)*noise_parameter*2e-04
intensity=doublesigmoidalFitFormula(time,
                                   finalAsymptoteIntensity=.3,
                                   maximum=2e-04,
                                   slope1=1,
                                   midPoint1=7,
                                   slope2=1,
                                   midPointDistance=8)
intensity=intensity+intensity_noise

dataInput=data.frame(intensity=intensity,time=time)
normalizeInput= normalizeData(dataInput,dataInputName="batch_01_21_2016_samp007623")


# Fit linear model
linearModel=fitFunction(dataInput=normalizeInput,
                                 model="linear",
                                 n_runs_min=20,
                                 n_runs_max=500,
                                 showDetails=FALSE)

isThis_nosignal=categorize_nosignal(parameterVectorLinear=linearModel)

}

