% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict-functions.R
\name{predict_kinematics}
\alias{predict_kinematics}
\alias{predict_velocity_at_time}
\alias{predict_distance_at_time}
\alias{predict_acceleration_at_time}
\alias{predict_time_at_distance}
\alias{predict_time_at_distance_FV}
\alias{predict_velocity_at_distance}
\alias{predict_acceleration_at_distance}
\alias{predict_acceleration_at_velocity}
\alias{predict_air_resistance_at_time}
\alias{predict_air_resistance_at_distance}
\alias{predict_force_at_velocity}
\alias{predict_force_at_time}
\alias{predict_force_at_distance}
\alias{predict_power_at_distance}
\alias{predict_power_at_time}
\alias{predict_relative_power_at_distance}
\alias{predict_relative_power_at_time}
\alias{predict_work_till_time}
\alias{predict_work_till_distance}
\title{Kinematics prediction functions}
\usage{
predict_velocity_at_time(time, MSS, MAC)

predict_distance_at_time(time, MSS, MAC)

predict_acceleration_at_time(time, MSS, MAC)

predict_time_at_distance(distance, MSS, MAC)

predict_time_at_distance_FV(
  distance,
  F0,
  V0,
  bodymass = 75,
  inertia = 0,
  resistance = 0,
  ...
)

predict_velocity_at_distance(distance, MSS, MAC)

predict_acceleration_at_distance(distance, MSS, MAC)

predict_acceleration_at_velocity(velocity, MSS, MAC)

predict_air_resistance_at_time(time, MSS, MAC, ...)

predict_air_resistance_at_distance(distance, MSS, MAC, ...)

predict_force_at_velocity(
  velocity,
  MSS,
  MAC,
  bodymass = 75,
  inertia = 0,
  resistance = 0,
  ...
)

predict_force_at_time(
  time,
  MSS,
  MAC,
  bodymass = 75,
  inertia = 0,
  resistance = 0,
  ...
)

predict_force_at_distance(
  distance,
  MSS,
  MAC,
  bodymass = 75,
  inertia = 0,
  resistance = 0,
  ...
)

predict_power_at_distance(
  distance,
  MSS,
  MAC,
  bodymass = 75,
  inertia = 0,
  resistance = 0,
  ...
)

predict_power_at_time(
  time,
  MSS,
  MAC,
  bodymass = 75,
  inertia = 0,
  resistance = 0,
  ...
)

predict_relative_power_at_distance(
  distance,
  MSS,
  MAC,
  bodymass = 75,
  inertia = 0,
  resistance = 0,
  ...
)

predict_relative_power_at_time(
  time,
  MSS,
  MAC,
  bodymass = 75,
  inertia = 0,
  resistance = 0,
  ...
)

predict_work_till_time(time, ...)

predict_work_till_distance(distance, ...)

predict_kinematics(
  object = NULL,
  MSS,
  MAC,
  max_time = 6,
  frequency = 100,
  bodymass = 75,
  inertia = 0,
  resistance = 0,
  add_inertia_to_vertical = TRUE,
  ...
)
}
\arguments{
\item{time, distance, velocity}{Numeric vectors}

\item{MSS, MAC}{Numeric vectors. Model parameters}

\item{F0, V0}{Numeric vectors. FV profile parameters}

\item{bodymass}{Body mass in kg. Used to calculate relative power and forwarded to \code{\link{get_air_resistance}}}

\item{inertia}{External inertia in kg (for example a weight vest, or a sled).
Not included in the air resistance calculation}

\item{resistance}{External horizontal resistance in Newtons (for example tether device or a sled friction resistance)}

\item{...}{
  Arguments passed on to \code{\link[=get_air_resistance]{get_air_resistance}}
  \describe{
    \item{\code{bodyheight}}{In meters (m). Default is 1.75m}
    \item{\code{barometric_pressure}}{In Torrs. Default is 760Torrs}
    \item{\code{air_temperature}}{In Celzius (C). Default is 25C}
    \item{\code{wind_velocity}}{In meters per second (m/s). Use negative number as head
wind, and positive number as back wind. Default is 0m/s (no wind)}
  }}

\item{object}{If \code{shorts_model} object is provided, estimated parameters
will be used. Otherwise provide \code{MSS} and \code{MAC} parameters}

\item{max_time}{Predict from 0 to \code{max_time}. Default is 6seconds}

\item{frequency}{Number of samples within one second. Default is 100Hz}

\item{add_inertia_to_vertical}{Should inertia be added to \code{bodymass} when
calculating vertical force? Use \code{TRUE} (Default) when using weight vest, and
\code{FALSE} when dragging sled}
}
\value{
Numeric vector

Data frame with kinetic and kinematic variables
}
\description{
Predicts kinematic from known \code{MSS} and \code{MAC} parameters
}
\examples{
MSS <- 8
MAC <- 9

time_seq <- seq(0, 6, length.out = 10)

df <- data.frame(
  time = time_seq,
  distance_at_time = predict_distance_at_time(time_seq, MSS, MAC),
  velocity_at_time = predict_velocity_at_time(time_seq, MSS, MAC),
  acceleration_at_time = predict_acceleration_at_time(time_seq, MSS, MAC)
)

df$time_at_distance <- predict_time_at_distance(df$distance_at_time, MSS, MAC)
df$velocity_at_distance <- predict_velocity_at_distance(df$distance_at_time, MSS, MAC)
df$acceleration_at_distance <- predict_acceleration_at_distance(df$distance_at_time, MSS, MAC)
df$acceleration_at_velocity <- predict_acceleration_at_velocity(df$velocity_at_time, MSS, MAC)

# Power calculation uses shorts::get_air_resistance function and its defaults
# values to calculate power. Use the ... to setup your own parameters for power
# calculations
df$power_at_time <- predict_power_at_time(
  time = df$time, MSS = MSS, MAC = MAC,
  # Check shorts::get_air_resistance for available params
  bodymass = 100, bodyheight = 1.85
)

df

# Example for predict_kinematics
split_times <- data.frame(
  distance = c(5, 10, 20, 30, 35),
  time = c(1.20, 1.96, 3.36, 4.71, 5.35)
)

# Simple model
simple_model <- with(
  split_times,
  model_timing_gates(distance, time)
)

predict_kinematics(simple_model)

}
\references{
Haugen TA, Tønnessen E, Seiler SK. 2012. The Difference Is in the Start: Impact of Timing and Start
        Procedure on Sprint Running Performance: Journal of Strength and Conditioning Research 26:473–479.
        DOI: 10.1519/JSC.0b013e318226030b.

Jovanović, M., Vescovi, J.D. (2020). shorts: An R Package for Modeling Short Sprints. Preprint
        available at SportRxiv. https://doi.org/10.31236/osf.io/4jw62

Samozino P. 2018. A Simple Method for Measuring Force, Velocity and Power Capabilities and Mechanical
        Effectiveness During Sprint Running. In: Morin J-B, Samozino P eds. Biomechanics of Training and Testing.
       Cham: Springer International Publishing, 237–267. DOI: 10.1007/978-3-319-05633-3_11.
}
