% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create-sprint-trace.R
\name{create_sprint_trace}
\alias{create_sprint_trace}
\title{Create Sprint Trace}
\usage{
create_sprint_trace(
  MSS,
  MAC,
  time = NULL,
  distance = NULL,
  TC = 0,
  DC = 0,
  FD = 0,
  remove_leading = FALSE
)
}
\arguments{
\item{MSS, MAC}{Numeric vector. Model parameters}

\item{time}{Numeric vector.}

\item{distance}{Numeric vector.}

\item{TC}{Numeric vector. Time-shift added to sprint times. Default is 0}

\item{DC}{Numeric vector. Distance-shift added to sprint distance. Default is 0}

\item{FD}{Numeric vector. Flying start distance. Default is 0}

\item{remove_leading}{Should trace leading to sprint be removed? Default is \code{FALSE}}
}
\value{
Data-frame with following 6 columns
    \describe{
       \item{time}{Measurement-scale time vector in seconds. Equal to parameter \code{time}}
       \item{distance}{Measurement-scale distance vector in meters. Equal to parameter \code{distance}}
       \item{velocity}{Velocity vector in m/s}
       \item{acceleration}{Acceleration vector in m/s/s}
       \item{sprint_time}{Sprint scale time vector in seconds. Sprint always start at t=0s}
       \item{sprint_distance}{Sprint scale distance vector in meters. Sprint always start at d=0m}
    }
}
\description{
This function creates sprint trace either using \code{time} or \code{distance} vectors
}
\examples{

df <- create_sprint_trace(8, 7, time = seq(0, 6, by = 0.01))
df <- create_sprint_trace(8, 7, distance = seq(0, 40, by = 1))

}
\seealso{
\code{\link{create_timing_gates_splits}}
}
