% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sum_shoredates.R
\name{sum_shoredates}
\alias{sum_shoredates}
\title{Sum the probability of multiple shoreline dates}
\usage{
sum_shoredates(
  shoreline_dates,
  cut_off = -2500,
  cut_off_level = 1,
  normalise = TRUE
)
}
\arguments{
\item{shoreline_dates}{Object of class \code{shoreline_date}.}

\item{cut_off}{Calendar year specifying where dates should be cut off.
Defaults to 2500 BCE.}

\item{cut_off_level}{Numerical value between 0 and 1 indicating the
probability mass that has to fall after the cut-off for a date to be
excluded. Defaults to 1, retaining all dates.}

\item{normalise}{Logical value indicating whether the probability sum of the
dates should be normalised to sum to unity. Defaults to TRUE.}
}
\value{
List of class \code{shoredate_sum} holding the elements:
\itemize{
\item \code{sum} data frame with the columns \code{bce} where negative values
indicate years BCE and positive CE, as well as \code{probability}, which gives
the probability mass for each year.
\item \code{dates_n} number of dates that make up the sum after applying any
specified cut-off. One date per site per isobase direction.
}
}
\description{
Function for finding the summed probability distribution of multiple
shoreline dates.
}
\examples{
target_points <- sf::st_sfc(sf::st_point(c(538310, 6544255)),
                            sf::st_point(c(538300, 6544250)))
target_points <- sf::st_as_sf(target_points, crs = 32632)

# Shoreline date, reducing resoltuion on elevation and calendar scales for
# speed.
target_dates <- shoreline_date(target_points,
                               elevation = c(65, 70),
                               elev_reso = 10,
                               cal_reso = 500)

sum_shoredates(target_dates)
}
