% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_code.R
\name{model_code}
\alias{model_code}
\title{Add model code to a shinystan object or see the code currently stored in 
a shinystan}
\usage{
model_code(sso, code)
}
\arguments{
\item{sso}{A shinystan object.}

\item{code}{Optionally, the code you want to add. See \strong{Details} below for 
formatting instructions.}
}
\value{
If \code{code} is missing then any code currently stored in
  \code{sso} is returned as a character string. If \code{code} is specified
  then then any previous code is overwritten by the text in \code{code} and
  an updated shinystan object is returned.
}
\description{
Add model code to a shinystan object or see the code currently stored in 
a shinystan
}
\details{
If \code{code} is specified it should be be a character string that
  can be used as an argument to \code{cat}. See \strong{Examples}, below.
}
\note{
For \pkg{rstan} users the model code will be automatically taken
from the stanfit object.
}
\examples{
\dontrun{
# Some JAGS-style code we might want to add
my_code <- "
 model {
   for (i in 1:length(Y)) {
     Y[i] ~ dpois(lambda[i])
     log(lambda[i]) <- inprod(X[i,], theta[])
   }
   for (j in 1:J) {
     theta[j] ~ dt(0.0, 1.0, 1.0)
   }
 }
"

# Add the code to a shinystan object sso
sso <- model_code(sso, my_code)

# View the code currently stored in sso
model_code(sso)

}
}
\seealso{
\code{cat}
}

