% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinyform.R
\name{ShinyForm}
\alias{ShinyForm}
\title{Class representing a ShinyForm form.}
\description{
ShinyForm can be used to include forms in your website. Create
a \code{ShinyForm} object anywhere in your application by
defining all the inputs (possibly adding validators) and by
specifying callback \code{onSuccess} and \code{onError} functions.
}
\details{
Parameters \code{onSuccess} and \code{onError} passed to the constructor
should be functions with signatures \code{function(self, input, output)},
where `self` will refer to the form itself, while \code{input} and
\code{output} will be the usual Shiny objects.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{id}}{Unique form id which can be used with Shiny input.}

\item{\code{elements}}{A list of ShinyForm input elements.}

\item{\code{onSuccess}}{A function with to be run on valid submission,
see details.}

\item{\code{onError}}{A function with to be run on invalid submission,
see details.}

\item{\code{submit}}{A submit Action button/link.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{ShinyForm$new()}}
\item \href{#method-ui}{\code{ShinyForm$ui()}}
\item \href{#method-server}{\code{ShinyForm$server()}}
\item \href{#method-getValue}{\code{ShinyForm$getValue()}}
\item \href{#method-clone}{\code{ShinyForm$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initialises a ShinyForm.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ShinyForm$new(id, submit, onSuccess, onError, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{Unique form identifier.}

\item{\code{submit}}{Submit button label.}

\item{\code{onSuccess}}{Function to be ran on successful validation.}

\item{\code{onError}}{Function to be ran on unsuccesful validation.}

\item{\code{...}}{A list of validated Shiny inputs.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ui"></a>}}
\if{latex}{\out{\hypertarget{method-ui}{}}}
\subsection{Method \code{ui()}}{
Returns the form's UI. To be used inside your
App's UI.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ShinyForm$ui()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-server"></a>}}
\if{latex}{\out{\hypertarget{method-server}{}}}
\subsection{Method \code{server()}}{
Form logic. To be inserted into your App's server function.

Will validate form upon hitting the "Submit" button
and run the `onSuccess` or `onError` function depending
on whether the form is valid.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ShinyForm$server(input, output)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Shiny input.}

\item{\code{output}}{Shiny output.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getValue"></a>}}
\if{latex}{\out{\hypertarget{method-getValue}{}}}
\subsection{Method \code{getValue()}}{
Returns value of the input element with a given ID.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ShinyForm$getValue(input, inputId)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input}}{Shiny input.}

\item{\code{inputId}}{ID of the input whose value is to be returned.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ShinyForm$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
