% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinylight.R
\name{sendInfoText}
\alias{sendInfoText}
\title{Sends informational text to the client.}
\usage{
sendInfoText(text)
}
\arguments{
\item{text}{The text to send}
}
\value{
No return value
}
\description{
During a slow remote procedure call, call this to inform the client
of progress.
}
\examples{
server <- slServer(
  port = 50051,
  interface = list(long_and_complicated = function(x) {
    # First part of work that takes some time
    # ...
    sendInfoText("We are about half way through")
    # Second part of work that takes some time
    # ...
  })
)
# ...
slStop(server)
}
\seealso{
\code{\link{sendProgress}} for sending a progress completion
ratio to the user.
}
