% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useShinyjs.R
\name{useShinyjs}
\alias{useShinyjs}
\title{Set up a Shiny app to use shinyjs}
\usage{
useShinyjs(rmd = FALSE, debug = FALSE, html = FALSE, showLog = FALSE)
}
\arguments{
\item{rmd}{Set this to \code{TRUE} only if you are using \code{shinyjs}
inside an interactive R markdown document. If using this option, view the
\href{https://github.com/daattali/shinyjs}{README} online to learn how to
use shinyjs in R markdown documents.}

\item{debug}{Set this to \code{TRUE} if you want to see detailed debugging
statements in the JavaScript console. Can be useful when filing bug reports
to get more information about what is going on.}

\item{html}{Set this to \code{TRUE} only if you are using \code{shinyjs} in
a Shiny app that builds the entire user interface with a custom HTML file. If
using this option, view the
\href{https://github.com/daattali/shinyjs}{README} online to learn
how to use shinyjs in these apps.}

\item{showLog}{Set this to \code{TRUE} if you want to print all JavaScript
log messages in the R console. This is useful for debugging. If using this
option, you must also call the \code{\link[shinyjs]{showLog}} function in
the server.}
}
\value{
Scripts that \code{shinyjs} requires that are automatically inserted
to the app's \code{<head>} tag.
}
\description{
This function must be called from a Shiny app's UI in order for all other
\code{shinyjs} functions to work.\cr\cr
You can call \code{useShinyjs()} from anywhere inside the UI.
}
\examples{
if (interactive()) {
  library(shiny)

  shinyApp(
    ui = fluidPage(
      useShinyjs(),  # Set up shinyjs
      actionButton("btn", "Click me"),
      textInput("element", "Watch what happens to me")
    ),
    server = function(input, output) {
      observeEvent(input$btn, {
        # Run a simply shinyjs function
        toggle("element")
      })
    }
  )
}
}
\seealso{
\code{\link[shinyjs]{runExample}}
\code{\link[shinyjs]{extendShinyjs}}
}

