% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elements.R
\name{glide}
\alias{glide}
\title{Glide component creation}
\usage{
glide(
  ...,
  id = NULL,
  next_label = paste("Next", shiny::icon("chevron-right", lib = "glyphicon")),
  previous_label = paste(shiny::icon("chevron-left", lib = "glyphicon"), "Back"),
  loading_label = span(span(class = "shinyglide-spinner"), span("Loading")),
  loading_class = "loading",
  disable_type = c("disable", "hide"),
  height = "100\%",
  keyboard = TRUE,
  custom_controls = NULL,
  controls_position = c("bottom", "top")
)
}
\arguments{
\item{...}{content of the glide.}

\item{id}{optional HTML id of the glide root element.}

\item{next_label}{label to be used in the "next" control.}

\item{previous_label}{label to be used in the "back" control.}

\item{loading_label}{label to be used in the "next" control when the next
screen is still loading.}

\item{loading_class}{class to add to the "next" control when the next
screen is still loading.}

\item{disable_type}{either to "disable" or "hide" the next or back control
when it is disabled by a condition.}

\item{height}{height of the glide (something like "400px" or "100\%").}

\item{keyboard}{set this to FALSE to disable keyboard navigation.}

\item{custom_controls}{custom HTML or shiny tags to be used for the controls.
If `NULL``, use the default ones.}

\item{controls_position}{either to place the default or custom controls on "top"
or "bottom" of the glide.}
}
\description{
Insert a glide component in the current shiny app UI
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

ui <- fixedPage(
 h3("Simple shinyglide app"),
 glide(
    screen(
      p("First screen.")
    ),
    screen(
      p("Second screen.")
    )
  )
)

server <- function(input, output, session) {
}

shinyApp(ui, server)

}

}
\seealso{
screen nextButton prevButton firstButton lastButton
}
