% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useful-items.R
\name{carousel}
\alias{carousel}
\title{AdminLTE2 carousel container}
\usage{
carousel(..., id, indicators = TRUE, width = 6, .list = NULL)
}
\arguments{
\item{...}{Slot for \link{carouselItem}}

\item{id}{Carousel id. Must be unique.}

\item{indicators}{Whether to display left and right indicators.}

\item{width}{Carousel width. 6 by default.}

\item{.list}{Should you need to pass \link{carouselItem} via \link{lapply} or similar,
put these item here instead of passing them in ...}
}
\description{
This creates a carousel
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinydashboard)
 shinyApp(
   ui = dashboardPagePlus(
     header = dashboardHeaderPlus(
      enable_rightsidebar = TRUE,
      rightSidebarIcon = "gears"
     ),
     sidebar = dashboardSidebar(),
     body = dashboardBody(
      carousel(
       id = "mycarousel",
       carouselItem(
        caption = "Item 1",
        tags$img(src = "https://placehold.it/900x500/3c8dbc/ffffff&text=I+Love+Bootstrap")
       ),
       carouselItem(
        caption = "Item 2",
        tags$img(src = "https://placehold.it/900x500/39CCCC/ffffff&text=I+Love+Bootstrap")
       )
      )
     ),
     rightsidebar = rightSidebar(),
     title = "Right Sidebar"
   ),
   server = function(input, output) { }
 )
}
}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
