% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module-selectizeGroup.R
\name{selectizeGroup-module}
\alias{selectizeGroup-module}
\alias{selectizeGroupUI}
\alias{selectizeGroupServer}
\title{Selectize Group}
\usage{
selectizeGroupUI(
  id,
  params,
  label = NULL,
  btn_label = "Reset filters",
  inline = TRUE
)

selectizeGroupServer(input, output, session, data, vars, inline = TRUE)
}
\arguments{
\item{id}{Module's id.}

\item{params}{A named list of parameters passed to each \code{selectizeInput}, you can use :
\code{inputId} (obligatory, must be variable name), \code{label}, \code{placeholder}.}

\item{label}{Character, global label on top of all labels.}

\item{btn_label}{Character, reset button label.}

\item{inline}{If \code{TRUE} (the default), \code{selectizeInput}s are horizontally positioned, otherwise vertically.}

\item{input, output, session}{standards \code{shiny} server arguments.}

\item{data}{Either a \code{\link[=data.frame]{data.frame()}} or a \code{\link[shiny:reactive]{shiny::reactive()}}
function returning a \code{data.frame} (do not use parentheses).}

\item{vars}{character, columns to use to create filters,
must correspond to variables listed in \code{params}. Can be a
\code{reactive} function, but values must be included in the initial ones (in \code{params}).}
}
\value{
a \code{\link[shiny:reactive]{shiny::reactive()}} function containing data filtered.
}
\description{
Group of mutually dependent \code{selectizeInput} for filtering data.frame's columns (like in Excel).
}
\examples{
# Default -----------------------------------------------------------------

if (interactive()) {

  library(shiny)
  library(shinyWidgets)

  data("mpg", package = "ggplot2")

  ui <- fluidPage(
    fluidRow(
      column(
        width = 10, offset = 1,
        tags$h3("Filter data with selectize group"),
        panel(
          selectizeGroupUI(
            id = "my-filters",
            params = list(
              manufacturer = list(inputId = "manufacturer", title = "Manufacturer:"),
              model = list(inputId = "model", title = "Model:"),
              trans = list(inputId = "trans", title = "Trans:"),
              class = list(inputId = "class", title = "Class:")
            )
          ), status = "primary"
        ),
        DT::dataTableOutput(outputId = "table")
      )
    )
  )

  server <- function(input, output, session) {
    res_mod <- callModule(
      module = selectizeGroupServer,
      id = "my-filters",
      data = mpg,
      vars = c("manufacturer", "model", "trans", "class")
    )
    output$table <- DT::renderDataTable(res_mod())
  }

  shinyApp(ui, server)

}

# Select variables --------------------------------------------------------

if (interactive()) {

  library(shiny)
  library(shinyWidgets)

  data("mpg", package = "ggplot2")

  ui <- fluidPage(
    fluidRow(
      column(
        width = 10, offset = 1,
        tags$h3("Filter data with selectize group"),
        panel(
          checkboxGroupInput(
            inputId = "vars",
            label = "Variables to use:",
            choices = c("manufacturer", "model", "trans", "class"),
            selected = c("manufacturer", "model", "trans", "class"),
            inline = TRUE
          ),
          selectizeGroupUI(
            id = "my-filters",
            params = list(
              manufacturer = list(inputId = "manufacturer", title = "Manufacturer:"),
              model = list(inputId = "model", title = "Model:"),
              trans = list(inputId = "trans", title = "Trans:"),
              class = list(inputId = "class", title = "Class:")
            )
          ),
          status = "primary"
        ),
        DT::dataTableOutput(outputId = "table")
      )
    )
  )

  server <- function(input, output, session) {

    vars_r <- reactive({
      input$vars
    })

    res_mod <- callModule(
      module = selectizeGroupServer,
      id = "my-filters",
      data = mpg,
      vars = vars_r
    )

    output$table <- DT::renderDataTable({
      req(res_mod())
      res_mod()
    })
  }

  shinyApp(ui, server)
}

# Subset data -------------------------------------------------------------

if (interactive()) {

  library(shiny)
  library(shinyWidgets)

  data("mpg", package = "ggplot2")

  ui <- fluidPage(
    fluidRow(
      column(
        width = 10, offset = 1,
        tags$h3("Filter data with selectize group"),
        panel(
          pickerInput(
            inputId = "car_select",
            choices = unique(mpg$manufacturer),
            options = list(
              `live-search` = TRUE,
              title = "None selected"
            )
          ),
          selectizeGroupUI(
            id = "my-filters",
            params = list(
              manufacturer = list(inputId = "manufacturer", title = "Manufacturer:"),
              model = list(inputId = "model", title = "Model:"),
              trans = list(inputId = "trans", title = "Trans:"),
              class = list(inputId = "class", title = "Class:")
            )
          ),
          status = "primary"
        ),
        DT::dataTableOutput(outputId = "table")
      )
    )
  )

  server <- function(input, output, session) {

    mpg_filter <- reactive({
      subset(mpg, manufacturer \%in\% input$car_select)
    })

    res_mod <- callModule(
      module = selectizeGroupServer,
      id = "my-filters",
      data = mpg_filter,
      vars = c("manufacturer", "model", "trans", "class")
    )

    output$table <- DT::renderDataTable({
      req(res_mod())
      res_mod()
    })
  }

  shinyApp(ui, server)
}
}
