% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/execute_safely.R
\name{execute_safely}
\alias{execute_safely}
\title{Execute an expression safely in server}
\usage{
execute_safely(
  expr,
  title = "Error",
  message = "An error occured, detail below:",
  include_error = TRUE,
  error_return = NULL,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{expr}{Expression to evaluate}

\item{title}{Title to display in the alert in case of error.}

\item{message}{Message to display below title.}

\item{include_error}{Include the error message generated by R.}

\item{error_return}{Value to return in case of error.}

\item{session}{Shiny session.}
}
\value{
Result of \code{expr} if no error, otherwise the value of
\code{error_return} (\code{NULL} by default to use \code{\link[shiny]{req}
 in other reactive context}).
}
\description{
Execute an expression without generating an error,
instead display the error to the user in an alert.
}
\examples{
library(shiny)
library(shinyWidgets)

ui <- fluidPage(
  tags$h2("Execute code safely in server"),
  fileInput(
    inputId = "file",
    label = "Try to import something else than a text file (Excel for example)"
  ),
  verbatimTextOutput(outputId = "file_value")
)

server <- function(input, output, session) {

  options(warn = 2) # turns warnings into errors
  onStop(function() {
    options(warn = 0)
  })

  r <- reactive({
    req(input$file)
    execute_safely(
      read.csv(input$file$datapath)
    )
  })

  output$file_value <- renderPrint({
    head(r())
  })

}

if (interactive())
  shinyApp(ui, server)
}
