% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-icon.R
\name{updateNumericInputIcon}
\alias{updateNumericInputIcon}
\title{Change the value of a numeric input icon on the client}
\usage{
updateNumericInputIcon(
  session,
  inputId,
  label = NULL,
  value = NULL,
  min = NULL,
  max = NULL,
  step = NULL
)
}
\arguments{
\item{session}{The \code{session} object passed to function given to
\code{shinyServer}.}

\item{inputId}{The id of the input object.}

\item{label}{The label to set for the input object.}

\item{value}{The value to set for the input object.}

\item{min}{Minimum value.}

\item{max}{Maximum value.}

\item{step}{Step size.}
}
\value{
No value.
}
\description{
Change the value of a numeric input icon on the client
}
\examples{
library(shiny)
library(shinyWidgets)

ui <- fluidPage(
  numericInputIcon(
    inputId = "ex1",
    label = "With an icon",
    value = 10,
    icon = icon("percent")
  ),
  actionButton("update", "Random value")
)

server <- function(input, output, session) {

  observeEvent(input$update, {
    updateNumericInputIcon(
      session = session,
      inputId = "ex1",
      value = sample.int(100, 1)
    )
  })

}

if (interactive())
  shinyApp(ui, server)
}
