% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conditionalJS.R
\docType{data}
\name{jsCalls}
\alias{jsCalls}
\alias{mergeCalls}
\title{List of JavaScript calls for `conditionalJS`}
\format{
An object of class \code{list} of length 6.
}
\usage{
jsCalls

mergeCalls(...)
}
\arguments{
\item{...}{jsCalls to be merged.}
}
\description{
Each `jsCalls` function can be used as a `jsCall` argument of \link{conditionalJS}.
See \link{js_calls} for possible options.

You can apply multiple calls with using `mergeCalls`.
}
\examples{
conditionalJS(
  shiny::tags$button("Hello"),
  "input.value > 0",
  jsCalls$show()
)
if (interactive()) {
  library(shiny)

  ui <- fluidPage(
    tags$head(
      tags$script(
        "var update_attr = function(message) {",
        "$('#' + message.id).attr(message.attribute, message.value);",
        "}",
        "Shiny.addCustomMessageHandler('update_attr', update_attr);"
      )
    ),
    sidebarLayout(
      sidebarPanel(
        selectInput("effect", "Animation type", choices = .cssEffects)
      ),
      mainPanel(
        conditionalJS(
          ui = plotOutput("cars"),
          condition = "input.effect != ''",
          jsCall = jsCalls$custom(true = runAnimation(effect = "bounce")),
          once = FALSE
        )
      )
    )
  )

  server <- function(input, output, session) {
    output$cars <- renderPlot({
      plot(mtcars$mpg, mtcars$qsec)
    })
    observeEvent(input$effect, {
      session$sendCustomMessage(
        "update_attr",
        list(id = "cars", attribute = "data-call-if-true", value = runAnimation(input$effect))
      )
    })
  }


  shinyApp(ui, server)
}

}
\keyword{datasets}
