% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/filechoose.R
\name{shinyFileChoose}
\alias{shinyFileChoose}
\title{Create a connection to the server side filesystem}
\usage{
shinyFileChoose(input, id, updateFreq = 2000, session, ...)
}
\arguments{
\item{input}{The input object of the \code{shinyServer()} call (usaully
\code{input})}

\item{id}{The same ID as used in the matching call to
\code{shinyFilesButton} or as the id attribute of the button, in case of a
manually defined html. This id will also define the id of the file choice in
the input variable}

\item{updateFreq}{The time in milliseconds between file system lookups. This
determines the responsiveness to changes in the filesystem (e.g. addition of
files or drives)}

\item{session}{The session object of the shinyServer call (usually
\code{session}).}

\item{...}{Arguments to be passed on to \code{\link{fileGetter}}}
}
\value{
A reactive observer that takes care of the server side logic of the
filesystem connection. Prior to v0.4.0 the return was a reactive expression
that needed to be assigned to the output variable. As of now this is no longer
allowed and will lead to an error (as reactive observers cannot be assigned
to output)
}
\description{
NOTE: The syntax for this version has changed with version 0.4.0. Prior to
that version the output of \code{shinyFileChoose()} should be assigned to the
output object. This is no longer the case and doind so will result in an
error. In newer versions the function returns an observer which can be
ignored for the most part, or assigned to a variable if there needs to be
interactions with it later on.
}
\details{
This function sets up the required connection to the client in order for the
user to navigate the filesystem. For this to work a matching button should be
present in the html, either by using \code{shinyFilesButton()} or adding it
manually. See \code{\link{shinyFilesButton}} for more information on this.

Restrictions on the access rights of the client can be given in several ways.
The root parameter specifies the starting position for the filesystem as
presented to the client. This means that the client can only navigate in
subdirectories of the root. Paths passed of to the \code{restrictions}
parameter will not show up in the client view, and it is impossible to
navigate into these subdirectories. The \code{filetypes} parameter takes a
vector of of file extensions to filter the output on, so that the client is
only presented with these filetypes. The \code{hidden} parameter toggles
whether hidden files should be visible or not. Whenever a file choice is made
the resulting files will be accessible in the input variable with the id
given in the parameters. This value should probable be run through a call to
\code{\link{parseFilePaths}} in order to get well formatted paths to work
with.
}
\examples{
\dontrun{
ui <- shinyUI(bootstrapPage(
    shinyFilesButton('files', 'File select', 'Please select a file', FALSE)
))
server <- shinyServer(function(input, output, session) {
    shinyFileChoose(input, 'files', session=session,
                    roots=c(wd='.'), filetypes=c('', '.txt'))
})

runApp(list(
    ui=ui,
    server=server
))
}
}
\seealso{
Other shinyFiles: \code{\link{parseFilePaths}};
  \code{\link{shinyFilesButton}};
  \code{\link{shinyFilesExample}}
}

