% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_config.R
\name{create_config_wizard}
\alias{create_config_wizard}
\title{Create configuration and app.R files}
\usage{
create_config_wizard(target_dir)
}
\arguments{
\item{target_dir}{location where the configuration will be saved}
}
\value{
Creates configuration file in \code{target_dir}
}
\description{
This function runs an interactive wizard that guides the user through the
creation of a basic configuration file. The wizard will work with the simple
case of expression data where one sample matches exactly to one subject.
}
\details{
Before you run the wizard, you should ensure that the target folder contains
at least the expression matrix and measures data files. The expression
matrix should follow the format of sample IDs in columns and genes in rows,
with gene names in the first column of the table. The measures file should
follow the format of subjects in rows and measures in columns, and you should
ensure that all subjects have one sample and vice-versa.
}
\examples{
if (interactive()) {
    dir.create("newapp")
    create_config_wizard("newapp")
}
}
