% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_output.R
\name{log_output}
\alias{log_output}
\title{Logging output of a function}
\usage{
log_output(..., type = "OUTPUT", status = "FIRED", params = NULL)
}
\arguments{
\item{...}{A function call that is evaluated, coerced into character string,
collapsed and pasted as multi-line text into log entry body.
Deparsed function call is used as the event name in log entry header.}

\item{type}{A character string. A type of the event.
Default is \code{"OUTPUT"}.}

\item{status}{A character string. A status of the event.
Default is \code{"FIRED"}.}

\item{params}{A list of additional named event-specific parameters.
Default is \code{NULL}.}
}
\description{
\code{log_output} logs output of a function into log entry body
and uses deparsed function call as the event name.
}
\examples{
if (interactive()) {
  set_logging()
  shiny::shinyApp(
    ui = shiny::fluidPage(log_init()),
    server = function(input, output) {
      set_logging_session()
      log_output(NROW(mtcars))
      log_output(head(mtcars))
    }
  )

}
}
\seealso{
Other logging events functions: \code{\link{log_event}},
  \code{\link{log_message}}, \code{\link{log_started}},
  \code{\link{log_test}}, \code{\link{log_value}}
}
\concept{logging events functions}
