% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chakraPinInput.R
\name{chakraPinInput}
\alias{chakraPinInput}
\title{Pin input}
\usage{
chakraPinInput(
  id,
  label = NULL,
  nfields,
  type = "alphanumeric",
  size = "md",
  mask = FALSE,
  defaultValue = ""
)
}
\arguments{
\item{id}{input id}

\item{label}{optional label}

\item{nfields}{number of fields}

\item{type}{either \code{"alphanumeric"} or \code{"number"}}

\item{size}{one of \code{"xs"}, \code{"sm"}, \code{"md"}, \code{"lg"}}

\item{mask}{Boolean, whether to mask the user inputs (like a password input)}

\item{defaultValue}{default value, can be partial}
}
\value{
A widget to use in \code{\link{chakraComponent}}.
}
\description{
Create a pin input widget.
}
\examples{
library(shiny)
library(shinyChakraUI)

ui <- chakraPage(
  br(),
  chakraComponent(
    "mycomponent",
    chakraPinInput(
      "pininput", label = tags$h2("Enter password"),
      nfields = 3, mask = TRUE
    )
  )
)

server <- function(input, output, session){

  observe({
    print(input[["pininput"]])
  })

}

if(interactive()){
  shinyApp(ui, server)
}
}
