% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chakraAlertDialog.R
\name{chakraAlertDialog}
\alias{chakraAlertDialog}
\title{Alert dialog widget}
\usage{
chakraAlertDialog(
  inputId,
  options = chakraAlertDialogOptions(),
  openButton,
  header,
  body,
  footer
)
}
\arguments{
\item{inputId}{widget id}

\item{options}{named list of options created with
\code{\link{chakraAlertDialogOptions}}}

\item{openButton}{a Chakra button to open the alert dialog}

\item{header}{an \code{AlertDialogHeader} element}

\item{body}{an \code{AlertDialogBody} element}

\item{footer}{an \code{AlertDialogFooter} element; usually it contains
some Chakra buttons (that you can group with \code{Tag$ButtonGroup(...)})}
}
\value{
A widget that can be used in \code{\link{chakraComponent}}.
}
\description{
An alert dialog widget.
}
\details{
You can use an \code{action} attribute and a \code{value}
  attribute to the Chakra buttons you put in the widget. For example, if
  you include the Chakra button
  \code{Tag$Button("Cancel", action = "cancel", value = "CANCEL")}, clicking
  this button will cancel the alert dialog and will set the Shiny value
  \code{"CANCEL"}. Other possible action attributes are \code{"close"} to
  close the alert dialog, \code{"disable"} to disable the alert dialog, and
  \code{"remove"} to entirely remove the widget.
}
\examples{
library(shiny)
library(shinyChakraUI)

ui <- chakraPage(

  br(),

  chakraComponent(
    "mycomponent",

    chakraAlertDialog(
      inputId = "alertDialog",
      openButton = Tag$Button(
        leftIcon = Tag$DeleteIcon(),
        colorScheme = "red",
        "Delete customer"
      ),
      header = Tag$AlertDialogHeader(
        fontSize = "lg",
        fontWeight = "bold",
        "Delete customer?"
      ),
      body = Tag$AlertDialogBody(
        "Are you sure? You can't undo this action afterwards."
      ),
      footer = Tag$AlertDialogFooter(
        Tag$ButtonGroup(
          spacing = "3",
          Tag$Button(
            action = "cancel",
            value = "CANCEL",
            "Cancel"
          ),
          Tag$Button(
            action = "disable",
            value = "DISABLE",
            colorScheme = "red",
            "Disable"
          ),
          Tag$Button(
            action = "remove",
            value = "REMOVE",
            "Remove"
          )
        )
      )
    )

  )

)

server <- function(input, output, session){

  observe({
    print(input[["alertDialog"]])
  })

}

if(interactive()){
  shinyApp(ui, server)
}
}
