% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slider.R
\name{uislider}
\alias{uislider}
\alias{uirange}
\title{Create Semantic UI Slider}
\usage{
uislider(name, value, min, max, step = 1, type = NULL)

uirange(name, value, value2, min, max, step = 1, type = NULL)
}
\arguments{
\item{name}{Input name. Reactive value is available under \code{input[[name]]}.}

\item{value}{The initial value to be selected for the sldier (lower value if using range).}

\item{min}{The minimum value allowed to be selected for the slider.}

\item{max}{The maximum value allowed to be selected for the slider.}

\item{step}{The interval between each selectable value of the slider.}

\item{type}{UI class of the slider. Can include \code{"Labeled"} and \code{"ticked"}.}

\item{value2}{The initial upper value of the slider.}
}
\description{
This creates a slider input using Semantic UI. Slider is already initialized and
available under \code{input[[name]]}.
}
\details{
Use \code{\link{update_slider}} to update the slider/range within the shiny session.
}
\examples{
if (interactive()) {

  library(shiny)
  library(shiny.semantic)

  # Slider example
  ui <- shinyUI(
    semanticPage(
      title = "Slider example",
      tags$br(),
      uislider("slider", 10, 0, 20),
      p("Selected value:"),
      textOutput("slider")
    )
  )

   server <- shinyServer(function(input, output, session) {
     output$slider <- renderText(input$slider)
   })

   shinyApp(ui = ui, server = server)

   # Range example
   ui <- shinyUI(
     semanticPage(
       title = "Range example",
       tags$br(),
       uirange("range", 10, 15, 0, 20),
       p("Selected values:"),
       textOutput("range")
    )
  )

   server <- shinyServer(function(input, output, session) {
     output$range <- renderText(paste(input$range, collapse = " - "))
   })

   shinyApp(ui = ui, server = server)

 }

}
\seealso{
update_slider for input updates,
\url{https://fomantic-ui.com/modules/slider.html} for preset classes.
}
