% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_pareto_chart.R
\name{draw_pareto_chart}
\alias{draw_pareto_chart}
\title{Draw Pareto Chart}
\usage{
draw_pareto_chart(
  data,
  cat_var,
  continuous_var,
  highlight_first_n_items = 0,
  lump_last_n_items = 0,
  lumped_cat_name = "Other",
  column_fill = scale_fill_sherlock(3),
  scale = "numeric",
  title_label = "Pareto Chart",
  analysis_desc_label = NULL,
  axis_text_size = 10
)
}
\arguments{
\item{data}{input dataset to be plotted (required)}

\item{cat_var}{Categorical variable (required)}

\item{continuous_var}{Continuous variable to rank by (e.g. sum, frequency etc.)  (required)}

\item{highlight_first_n_items}{Specify the top n items to be highlighted. By default, it is set to 0. (optional)}

\item{lump_last_n_items}{Specify the last n items to be lumped into one category. By default, it is set to 0. (optional)}

\item{lumped_cat_name}{Name lumped category. By default, it is set to "Other". (optional)}

\item{column_fill}{Column fill color. By default, it is set to scale_fill_sherlock(3) (optional)}

\item{scale}{Specify an acceptable argument for scale. Acceptable arguments are "numeric", "percent", "dollar", "dollar-k" or "dollar-M". By default, it is set to "numeric" (optional)}

\item{title_label}{Specify plot title. By default, it is set to display "Pareto Chart" (optional)}

\item{analysis_desc_label}{Specify plot analysis desc label (subtitle). By default, it is set to display CONTINUOUS VARIABLE COLUMN NAME "by" CATEGORICAL VARIABLE COLUMN NAME (optional)}

\item{axis_text_size}{Set axis text size. By default, it is set at 10. (optional)}
}
\value{
A 'ggplot' object
}
\description{
Draws a Pareto Chart
}
