% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_categorical_scatterplot.R
\name{draw_categorical_scatterplot}
\alias{draw_categorical_scatterplot}
\title{Draw Categorical Scatterplot}
\usage{
draw_categorical_scatterplot(
  data,
  y_var,
  grouping_var_1,
  grouping_var_2,
  grouping_var_3,
  group_color = FALSE,
  size = 2,
  alpha = 0.5,
  jitter = TRUE,
  interactive = FALSE
)
}
\arguments{
\item{data}{input dataset to be plotted (required)}

\item{y_var}{Y variable to be plotted on Y axis (required)}

\item{grouping_var_1}{First grouping variable (optional)}

\item{grouping_var_2}{Second, higher-level grouping variable  (optional)}

\item{grouping_var_3}{Third, highest-level grouping variable (optional)}

\item{group_color}{Set whether to color by grouping_var_1. By default, it is set to FALSE (optional)}

\item{size}{Set point size. By default, it is set to 2  (optional)}

\item{alpha}{Set transparency. By default, it is set to 0.5  (optional)}

\item{jitter}{Set whether to add jitter. By default, it is set to TRUE  (optional)}

\item{interactive}{Set plot interactivity. By default, it is set to FALSE (optional)}
}
\value{
A 'ggplot' or 'plotly' object
}
\description{
Draws a Categorical Scatterplot
}
\examples{
multi_vari_data_2 \%>\%
   draw_categorical_scatterplot(y_var = Length,
                                grouping_var_1 = Part,
                                grouping_var_2 = Operator,
                                jitter = FALSE)

}
