#' Calculates the delta for a given # of samples and value of epsilon.
#'
#' @description Calculates the delta for a given # of samples and value of epsilon.
#'
#' @param rpart.tree rpart.tree. A Decision tree generated by rpart package.
#' @param samples int. The # of samples to be used in delta calculation.
#' @param epsilon float. The epsilon to be used in the delta calculation.
#'
#' @usage compute_delta(rpart.tree, samples, epsilon)
#'
#' @return computed delta for # of samples and epsilon given as input.
#'
#' @export compute_delta
compute_delta <- function(rpart.tree, samples, epsilon){
    shattering <- compute_shattering(rpart.tree, samples)
    delta <- 2*shattering*exp(-samples*((epsilon**2)/4))

    return (delta)
}
