% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collapse_shap.R
\name{collapse_shap}
\alias{collapse_shap}
\title{Collapse SHAP values}
\usage{
collapse_shap(S, collapse = NULL, ...)
}
\arguments{
\item{S}{Either a (n x p) matrix of SHAP values or a (n x p x p) array of SHAP
interaction values.}

\item{collapse}{A named list of character vectors. Each vector specifies the
feature names whose SHAP values need to be summed up.
The list names determine the resulting collapsed column/dimension names.}

\item{...}{Currently unused.}
}
\value{
A matrix of SHAP values, or an array of SHAP interaction values.
}
\description{
This function sums up SHAP values (or SHAP interaction values) of feature groups.
Typical application: SHAP values have been generated by a model with one or multiple
one-hot encoded variables, but the explanations should be done using the
original factor.
}
\examples{
S <- cbind(
  x = c(0.1, 0.1, 0.1),
  `age low` = c(0.2, -0.1, 0.1),
  `age mid` = c(0, 0.2, -0.2),
  `age high` = c(1, -1, 0)
)
collapse <- list(age = c("age low", "age mid", "age high"))
collapse_shap(S, collapse)

# Arrays (as with SHAP interactions)
S_inter <- array(1, dim = c(2, 4, 4), dimnames = list(NULL, letters[1:4], letters[1:4]))
collapse_shap(S_inter, collapse = list(cd = c("c", "d"), ab = c("a", "b")))
}
