% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asymmetric_and_casual_Shapley.R
\name{get_max_n_coalitions_causal}
\alias{get_max_n_coalitions_causal}
\title{Get the number of coalitions that respects the causal ordering}
\usage{
get_max_n_coalitions_causal(causal_ordering)
}
\arguments{
\item{causal_ordering}{List.
Not applicable for (regular) non-causal or asymmetric explanations.
\code{causal_ordering} is an unnamed list of vectors specifying the components of the
partial causal ordering that the coalitions must respect. Each vector represents
a component and contains one or more features/groups identified by their names
(strings) or indices (integers). If \code{causal_ordering} is \code{NULL} (default), no causal
ordering is assumed and all possible coalitions are allowed. No causal ordering is
equivalent to a causal ordering with a single component that includes all features
(\code{list(1:n_features)}) or groups (\code{list(1:n_groups)}) for feature-wise and group-wise
Shapley values, respectively. For feature-wise Shapley values and
\code{causal_ordering = list(c(1, 2), c(3, 4))}, the interpretation is that features 1 and 2
are the ancestors of features 3 and 4, while features 3 and 4 are on the same level.
Note: All features/groups must be included in the \code{causal_ordering} without any duplicates.}
}
\value{
Integer. The (maximum) number of coalitions that respects the causal ordering.
}
\description{
Get the number of coalitions that respects the causal ordering
}
\details{
The function computes the number of coalitions that respects the causal ordering by computing the number
of coalitions in each partial causal component and then summing these. We compute
the number of coalitions in the \eqn{i}th a partial causal component by \eqn{2^n - 1},
where \eqn{n} is the number of features in the the \eqn{i}th partial causal component
and we subtract one as we do not want to include the situation where no features in
the \eqn{i}th partial causal component are present. In the end, we add 1 for the
empty coalition.
}
\examples{
\dontrun{
get_max_n_coalitions_causal(list(1:10)) # 2^10 = 1024 (no causal order)
get_max_n_coalitions_causal(list(1:3, 4:7, 8:10)) # 30
get_max_n_coalitions_causal(list(1:3, 4:5, 6:7, 8, 9:10)) # 18
get_max_n_coalitions_causal(list(1:3, c(4, 8), c(5, 7), 6, 9:10)) # 18
get_max_n_coalitions_causal(list(1, 2, 3, 4, 5, 6, 7, 8, 9, 10)) # 11
}

}
\author{
Lars Henry Berge Olsen
}
\keyword{internal}
