% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapeR.R
\name{smoothout}
\alias{smoothout}
\title{Contour smoothing}
\usage{
smoothout(object, n)
}
\arguments{
\item{object}{A \code{\linkS4class{shapeR}} object}

\item{n}{The number of iterations. The default value is 100.}
}
\value{
A \code{\linkS4class{shapeR}} object with smoothed otolith outlines in the slot outline.list
}
\description{
Remove high frequency pixel noise around the otolith outline
}
\examples{

\donttest{
data(shape)
shape = smoothout(shape,n=100)

# Plot smoothed outline on top of original outline for comparison
outline.org=shape@outline.list.org[["IC"]][["403_2"]]
outline=shape@outline.list[["IC"]][["403_2"]]
plot(outline.org$X,outline.org$Y,type='l',xlab="",ylab="",lwd=2,axes=FALSE)
lines(outline$X,outline$Y,col="red",lwd=2)
legend("bottomleft",c('Original','Smoothed'),lty=1,col=c('black','red'),lwd=2)}

}
\references{
Haines, A.J., Crampton, J.S. (2000). Improvements to the method of Fourier shape analysis as applied in morphometric studies. Palaeontology 43: 765-783.

Claude, J. (2008) Morphometrics with R. Springer. 316 p.
}
\author{
Lisa Anne Libungan
}
