% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scales.R
\name{gradient}
\alias{gradient}
\title{Colour gradients}
\usage{
gradient(shades, steps, space = NULL)
}
\arguments{
\item{shades}{One or more colours, in any suitable form (see
\code{\link{shade}}).}

\item{steps}{A vector giving the number of steps required  between each key
colour. Should have length one less than \code{shades}.}

\item{space}{The colour space to traverse. Defaults to the current space of
\code{shades}.}
}
\value{
A character vector of class \code{"shade"} containing the gradient
  elements in the specified space.
}
\description{
This function returns a set of colours interpolating between the specified
key colours, equally separated in the specified space.
}
\examples{
gradient(c("red","blue"), 5)
gradient(c("red","blue"), 5, space="LAB")
}
\author{
Jon Clayden <code@clayden.org>
}

