% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_existing_clhs.R
\name{sample_existing_clhs}
\alias{sample_existing_clhs}
\title{Sub-sample using the conditional Latin hypercube sampling (CLHS)}
\usage{
sample_existing_clhs(
  existing,
  nSamp,
  raster = NULL,
  cost = NULL,
  iter = 10000,
  details = FALSE,
  filename = NULL,
  overwrite = FALSE,
  ...
)
}
\arguments{
\item{existing}{sf 'POINT'.  Existing plot network.}

\item{nSamp}{Numeric. Number of desired samples.}

\item{cost}{Numeric/Character. Index or name of covariate within \code{mraster} to be used to constrain cLHS sampling.
If default (\code{NULL}), a cost constraint is not used.}

\item{iter}{Numeric. Value giving the number of iterations within the Metropolis-Hastings process.}

\item{details}{Logical. If \code{FALSE} (default) output is only
stratification raster. If \code{TRUE} return a list where \code{$details} is additional
stratification information and \code{$raster} is the output stratification spatRaster.}

\item{filename}{Character. Path to write output samples.}

\item{overwrite}{Logical. Choice to overwrite existing \code{filename} if it exists.}

\item{...}{Additional arguments for clhs sampling. See \code{\link[clhs]{clhs}}.}
}
\value{
A subsampled SpatialPointsDataFrame object.
}
\description{
This function takes an existing \code{sf} object and returns a random sub-sample of size \code{nSamp}.
}
\keyword{internal}
