% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_representation.R
\name{calculate_representation}
\alias{calculate_representation}
\title{Compare sample representation within sraster strata}
\usage{
calculate_representation(sraster, existing, drop = NULL, plot = FALSE)
}
\arguments{
\item{sraster}{spatRaster. Stratification raster.}

\item{existing}{sf 'POINT'.  Existing plot network.}

\item{drop}{Numeric. Numeric value between 0-1 representing the \code{sraster} frequency
(\code{srasterFreq}) below which strata will be dropped from comparison (e.g..
This parameter can be useful for when comparing stratum where percent coverage of strata
may be ~ 0 percent and should be dropped. This could occur when mapping multiple stratifications.}

\item{plot}{Logical. Plot frequency of strata coverage and sampling coverage
for \code{sraster} and \code{existing}. Will return a list if \code{TRUE}.}
}
\value{
Returns a tibble where:
\itemize{
\item{strata} - \code{sraster} strata ID.
\item{srasterFreq} - \code{sraster} coverage frequency.
\item{sampleFreq} - Sampling frequency within \code{sraster} strata.
\item{diffFreq} - Difference between \code{srasterFreq} & \code{sampleFreq}. Positive values indicate over representation.
\item{nSamp} - Number of samples within each strata in \code{existing}.
\item{need} - \code{srasterFreq * sum(nSamp)}. Total theoretical number of required samples to be representative of strata coverage.
This values is rounded. It is important for the user to consider \code{diffFreq}. A small difference - e.g. 1 % -
in \code{sampleFreq} vs. \code{srasterFreq} frequency could make the algorithm allocate or remove samples that could likely be ignored.
}
}
\description{
Compare sample representation within sraster strata
}
\details{
Calculate how sraster strata are represented in existing samples
}
\examples{
### --- generate example stratification ---###

#--- load ALS metrics from sgsR internal data ---#
r <- system.file("extdata", "mraster.tif", package = "sgsR")

#--- read ALS metrics using the terra package ---#
mraster <- terra::rast(r)

#--- perform stratification ---#
sraster <- strat_kmeans(
  mraster = mraster$zq90,
  nStrata = 6
)

### --- create existing sample network ---###

#--- simple random sampling ---#
existing <- sample_srs(
  raster = mraster$zq90,
  nSamp = 100
)

#--- calculate representation ---#

calculate_representation(
  sraster = sraster,
  existing = existing
)
}
\seealso{
Other calculate functions: 
\code{\link{calculate_allocation}()},
\code{\link{calculate_allocation_existing}()},
\code{\link{calculate_coobs}()},
\code{\link{calculate_distance}()},
\code{\link{calculate_pcomp}()},
\code{\link{calculate_pop}()},
\code{\link{calculate_sampsize}()}
}
\author{
Tristan R.H. Goodbody, Martin Queinnec
}
\concept{calculate functions}
