% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_pcomp.R
\name{calculate_pcomp}
\alias{calculate_pcomp}
\title{Raster principal components}
\usage{
calculate_pcomp(
  mraster,
  nComp,
  center = TRUE,
  scale = TRUE,
  maxcells = Inf,
  plot = FALSE,
  details = FALSE,
  filename = NULL,
  overwrite = FALSE,
  ...
)
}
\arguments{
\item{mraster}{spatRaster. ALS metrics raster.}

\item{nComp}{Numeric. Value indicating number of principal components to be rasterized.}

\item{center}{Logical. Value indicating whether the variables should be shifted to be zero centered.}

\item{scale}{Logical. Value indicating whether the variables should be scaled to have unit variance.}

\item{maxcells}{Numeric. Maximum number of samples to use to generate principal components.
For objects that are too large to feed into \code{\link[stats]{prcomp}}.}

\item{plot}{Logical. Plots output strata raster with samples.}

\item{details}{Logical. If \code{FALSE} (default) output is only
stratification raster. If \code{TRUE} return a list where \code{$details} is additional
stratification information and \code{$raster} is the output stratification spatRaster.}

\item{filename}{Character. Path to write output samples.}

\item{overwrite}{Logical. Choice to overwrite existing \code{filename} if it exists.}

\item{...}{Additional arguments to be passed to \code{\link[stats]{prcomp}}.}
}
\value{
Output raster with specified number of principal components as layers.
}
\description{
Calculate and rasterize principal components from a metric raster
}
\examples{
#--- Load raster ---#
r <- system.file("extdata", "mraster.tif", package = "sgsR")
mr <- terra::rast(r)

calculate_pcomp(
  mraster = mr,
  nComp = 2
)

pcomp <- calculate_pcomp(
  mraster = mr,
  nComp = 3,
  details = TRUE
)

#--- Display principal component details ---#
# pcomp$pca

#--- Display importance of components ---#
# summary(pcomp$pca)
}
\seealso{
Other calculate functions: 
\code{\link{calculate_allocation}()},
\code{\link{calculate_allocation_existing}()},
\code{\link{calculate_coobs}()},
\code{\link{calculate_distance}()},
\code{\link{calculate_pop}()},
\code{\link{calculate_representation}()},
\code{\link{calculate_sampsize}()}
}
\author{
Tristan R.H. Goodbody
}
\concept{calculate functions}
