% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sigma_attrs.R
\name{add_node_size}
\alias{add_node_size}
\title{Modify the node size of a sgraph object.}
\usage{
add_node_size(
  sigma_obj,
  min_size = 1,
  max_size = 3,
  one_size = NULL,
  size_vector = NULL
)
}
\arguments{
\item{sigma_obj}{sgraph object, returned by sigma_from_igraph function}

\item{min_size}{Minimum node size on the graph (for scaling)}

\item{max_size}{Maximum node size on the graph (for scaling)}

\item{one_size}{A single size to use for all nodes}

\item{size_vector}{An optional vector with the sizes for each node}
}
\value{
A sgraph object with modified node sizes
}
\description{
Modify the node size of an existing sgraph object by providing either:
(1) A single size to use for all nodes; (2) a vector of node sizes; or (3) a
metric to use to scale the nodes.
}
\examples{
library(igraph)
library(sgraph)

data(lesMis)

layout <- layout_nicely(lesMis)

# one size for all nodes
sig <- sigma_from_igraph(igraph = lesMis, layout = layout) \%>\%
  add_node_size(one_size = 3)
sig

# using a vector
custom_size <- log10(degree(lesMis))
sig <- sigma_from_igraph(igraph = lesMis, layout = layout) \%>\%
 add_node_size(size_vector = custom_size)
sig

}
