\name{plot.point}
\title{Plot Point Objects}
\usage{plot.point(x, v, legend.pos=0,axes=TRUE,xlab='',ylab='', add=FALSE, ...) }
\alias{plot.point}
\arguments{
  \item{x}{a point object generated by \code{point()}}
  
  \item{v}{an optional variable name, if entered will divide the points into quantiles and color using 4 colors}
  \item{n}{\code{n}}
  \item{legend.pos}{position of legend (0 - none, 1 - bottom-left, 2
    -bottom-right, 3 - top-right, 4 - top-left), requires Lang(v)}
  \item{axes}{logical, whether to plot axes}
  \item{xlab,ylab}{axes labels, default none}
  \item{add}{usefull for overlaying \code{image}s with a \code{point}
    plot}
  \item{...}{additional arguments for \code{plot}}
}
\value{NULL}
\description{ Plot the spatial locations in a point object, optionally coloring by quantile.}
\seealso{\code{\link{point}}}
\examples{
\testonly{
if(length(ls(pat="maas.point"))==0){example(point)}
}
plot(maas.point) 
plot(maas.point,v='zinc') 
plot(maas.point,v='zinc',xlab='easting',ylab='northing',axes=TRUE,legend.pos=4)
# plot additionally the maas bank:
data(maas.bank)
lines(maas.bank)
}
\references{
http://www.gis.iastate.edu/SGeoStat/homepage.html
}
\keyword{spatial}
