% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_augment.R
\name{st_augment}
\alias{st_augment}
\title{Augment dataframe with predictions of model}
\usage{
st_augment(model, df)
}
\arguments{
\item{model}{an `mgcv`, `lme4` or `nlme` model.}

\item{df}{an `sf` data frame to be augmented with model predictions.}
}
\value{
An augmented `sf` data frame with extra columns showing estimates of random effects from model.
}
\description{
Augment dataframe with predictions of model
}
\examples{
prepdata <- st_bridges(uk_election,"constituency_name")
mgcv::gam(health_not_good ~
  s(constituency_name, bs='mrf', xt=list(nb=prepdata$nb), k=100),
  data=prepdata, method="REML") |>
st_augment(uk_election)
}
