% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sf_helpers.R
\name{sf_mpt}
\alias{sf_mpt}
\title{Helper for sf MULTIPOINT}
\usage{
sf_mpt(obj, keep = FALSE, list_columns = NULL)
}
\arguments{
\item{obj}{sorted vector, matrix or data.frame}

\item{keep}{logical indicating if the non-geometry and non-id columns should be kept.
if TRUE you must supply the geometry and id columns, and only the first row of
each geometry is kept. See Keeping Properties.}

\item{list_columns}{vector of column names to turn into a list.}
}
\value{
\code{sf} object of MULTIPOINT geometries
}
\description{
Constructs sf of MULTIPOINT objects, a helper for \code{\link[=sf_multipoint]{sf_multipoint()}} with a
simpler syntax.
}
\section{Helpers}{

These are simpler versions of the main functions \code{\link[=sf_point]{sf_point()}},
\code{\link[=sf_multipoint]{sf_multipoint()}}, \code{\link[=sf_linestring]{sf_linestring()}}, \code{\link[=sf_multilinestring]{sf_multilinestring()}}, \code{\link[=sf_polygon]{sf_polygon()}},
and \code{\link[=sf_multipolygon]{sf_multipolygon()}} for input data frame or matrix that contains columns
appropriately of 'x', 'y', 'z', 'm', ' multipolygon_id', polygon_id',
'multilinestring_id', 'linestring_id', 'multipoint_id'.

This puts the onus of the naming and identification of entities onto the
input data set, rather than when calling the creator function. This has pros
and cons, so is not necessarily always 'simpler'. Please choose the
appropriate constructor for the context you have. For examples a data frame
from the real world with columns 'lon', 'lat', 'line' will be best used with

\code{sf_linestring(df, x = "lon", y = "lat", linestring_id = "line")}

whereas a heavy user of sfheaders might always create a data frame with 'x',
'y', 'linestring_id' precisely because they are expecting to call
\code{sf_line(df)} and no further work is required. These are very different
contexts and both equally valid.

Some columns are mandatory, such as 'x' and 'y' (always), while others depend
on the output type where each column for that type is mandatory. The 'z'
and/or 'm' values are included for 'XYZ', 'XYM', or 'XYZM' geometry types if
and as they are present.

In summary these helpers:
\itemize{
\item do not require arguments declaring column names.
\item use assumed default column names, with no variation or absence allowed for
a given type.
\item use \code{z}, and/or \code{m} if present.
\item use \code{close = FALSE} and \code{keep = FALSE} same as proper constructors.
\item unlike \code{\link[=sf_point]{sf_point()}} \code{\link[=sf_pt]{sf_pt()}} does not accept a flat vector for a single
point.
\item require a matrix or data frame with complete column names.
}

None of the helpers allow partial name matching for column names.
}

\section{notes}{

sfheaders functions do not perform any validity checks on the geometries.
Nor do they set Coordinate Reference Systems, EPSG, PROJ4 or precision attributes.

The data.frame and matrices you send into the sfheader functions must be ordered.
}

\section{Keeping Properties}{


Setting \code{keep = TRUE} will retain any columns not specified as a
coordinate (x, y, z, m) or an id (e.g., linestring_id, polygon_id) of the input \code{obj}.

You can use \code{list_columns} to specify which of the properties will be turned into
a list, thus keeping all the values in the column. For columns not specified in \code{list_columns},
only the first row of the column is kept

The \code{sf_*} functions assume the input \code{obj} is a long data.frame / matrix,
where any properties are repeated down the table for the same geometry.
}

\examples{

x <- cbind(x = 1:2, y = 3:4, multipoint_id = 1, ncol = 2 )
sf_mpt( x )

x <- data.frame( id = 1:2, x = 1:2, y = 2:1, multipoint_id = 1)
sf_mpt( x )
sf_mpt( x, keep = TRUE)
x <- data.frame(multipoint_id = 1:2, id = 1:2, x = 1:2, y = 2:1 )
(sfx <- sf_mpt(x))

## we trivially round-trip with sf_mpt()
sf_mpt(sf_to_df(sfx))
}
