% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global-measures.R
\name{global_g_test}
\alias{global_g_test}
\title{Getis-Ord Global G}
\usage{
global_g_test(x, nb, wt, alternative = "greater", allow_zero = NULL, ...)
}
\arguments{
\item{x}{A numeric vector.}

\item{nb}{a neighbor list object for example as created by \code{st_contiguity()}.}

\item{wt}{a weights list as created by \code{st_weights()}.}

\item{alternative}{default \code{"two.sided"}. Should be one of \code{"greater"}, \code{"less"}, or \code{"two.sided"} to specify the alternative hypothesis.}

\item{allow_zero}{If \code{TRUE}, assigns zero as lagged value to zone without neighbors.}

\item{...}{additional methods passed to \code{\link[spdep:globalG.test]{spdep::globalG.test()}}.}
}
\value{
an \code{htest} object
}
\description{
Getis-Ord Global G
}
\examples{
geo <- sf::st_geometry(guerry)
nb <- st_contiguity(geo)
wt <- st_weights(nb, style = "B")
x <- guerry$crime_pers
global_g_test(x, nb, wt)
}
