% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom.R
\name{geos_unary}
\alias{geos_unary}
\alias{st_buffer}
\alias{geos_unary}
\alias{st_boundary}
\alias{geos_unary}
\alias{st_convex_hull}
\alias{geos_unary}
\alias{st_simplify}
\alias{geos_unary}
\alias{st_triangulate}
\alias{geos_unary}
\alias{st_voronoi}
\alias{geos_unary}
\alias{st_polygonize}
\alias{geos_unary}
\alias{st_line_merge}
\alias{geos_unary}
\alias{st_centroid}
\alias{geos_unary}
\alias{st_segmentize}
\title{Geometric unary operations on (pairs of) simple feature geometry sets}
\usage{
st_buffer(x, dist, nQuadSegs = 30)

st_boundary(x)

st_convex_hull(x)

st_simplify(x, preserveTopology = FALSE, dTolerance = 0)

st_triangulate(x, dTolerance = 0, bOnlyEdges = FALSE)

st_voronoi(x, envelope, dTolerance = 0, bOnlyEdges = FALSE)

st_polygonize(x)

st_line_merge(x)

st_centroid(x)

st_segmentize(x, dfMaxLength, ...)
}
\arguments{
\item{x}{object of class \code{sfg}, \code{sfg} or \code{sf}}

\item{dist}{numeric; buffer distance for all, or for each of the elements in \code{x}}

\item{nQuadSegs}{integer; number of segments per quadrant (fourth of a circle)}

\item{preserveTopology}{logical; carry out topology preserving simplification?}

\item{dTolerance}{numeric; tolerance parameter}

\item{bOnlyEdges}{logical; if TRUE, return lines, else return polygons}

\item{envelope}{object of class \code{sfc} or \code{sfg} with the envelope for a voronoi diagram}

\item{dfMaxLength}{maximum length of a line segment. If \code{x} has geographical coordinates (long/lat), \code{dfMaxLength} is either a numeric expressed in meter, or an object of class \code{units} with length units or unit \code{rad}, and segmentation takes place along the great circle, using \link[geosphere]{gcIntermediate}.}

\item{...}{ignored}
}
\value{
\code{st_buffer}, \code{st_boundary}, \code{st_convex_hull}, \code{st_simplify},
\code{st_triangulate}, \code{st_voronoi}, \code{st_polygonize}, \code{st_line_merge},
\code{st_centroid} and \code{st_segmentize} return an \link{sfc} or an \link{sf} 
object with the same number of geometries as \code{x}
}
\description{
Geometric unary operations on (pairs of) simple feature geometry sets
}
\details{
\code{st_triangulate} requires GEOS version 3.4 or above

\code{st_voronoi} requires GEOS version 3.4 or above

in case of \code{st_polygonize}, \code{x} must be an object of class \code{LINESTRING} or \code{MULTILINESTRING}, or an \code{sfc} geometry list-column object containing these

in case of \code{st_line_merge}, \code{x} must be an object of class \code{MULTILINESTRING}, or an \code{sfc} geometry list-column object containing these
}
\examples{
nc = st_read(system.file("shape/nc.shp", package="sf"))
plot(st_convex_hull(nc))
plot(nc, border = grey(.5))
set.seed(1)
x = st_multipoint(matrix(runif(10),,2))
box = st_polygon(list(rbind(c(0,0),c(1,0),c(1,1),c(0,1),c(0,0))))
if (sf_extSoftVersion()["GEOS"] >= "3.5.0") {
 v = st_sfc(st_voronoi(x, st_sfc(box)))
 plot(v, col = 0, border = 1, axes = TRUE)
 plot(box, add = TRUE, col = 0, border = 1) # a larger box is returned, as documented
 plot(x, add = TRUE, col = 'red', cex=2, pch=16)
 plot(st_intersection(st_cast(v), box)) # clip to smaller box
 plot(x, add = TRUE, col = 'red', cex=2, pch=16)
}
mls = st_multilinestring(list(matrix(c(0,0,0,1,1,1,0,0),,2,byrow=TRUE)))
st_polygonize(st_sfc(mls))
mls = st_multilinestring(list(rbind(c(0,0), c(1,1)), rbind(c(2,0), c(1,1))))
st_line_merge(st_sfc(mls))
plot(nc, axes = TRUE)
plot(st_centroid(nc), add = TRUE, pch = 3)
sf = st_sf(a=1, geom=st_sfc(st_linestring(rbind(c(0,0),c(1,1)))), crs = 4326)
seg = st_segmentize(sf, units::set_units(100, km))
seg = st_segmentize(sf, units::set_units(0.01, rad))
nrow(seg$geom[[1]])
}
