% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-project.R
\name{Project}
\alias{Project}
\title{R6 Class representing a project.}
\description{
R6 Class representing a central resource for managing projects.
}
\examples{

## ------------------------------------------------
## Method `Project$print`
## ------------------------------------------------

\dontrun{
 # x is API response when project is requested
 project_object <- Project$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Print project object
 project_object$print()
}


## ------------------------------------------------
## Method `Project$detailed_print`
## ------------------------------------------------

\dontrun{
 # x is API response when project is requested
 project_object <- Project$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Print project object in detail
 project_object$detailed_print()
}


## ------------------------------------------------
## Method `Project$reload`
## ------------------------------------------------

\dontrun{
 # x is API response when project is requested
 project_object <- Project$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Reload project object
 project_object$reload()
}


## ------------------------------------------------
## Method `Project$update`
## ------------------------------------------------

\dontrun{
 # x is API response when project is requested
 project_object <- Project$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Change project object name
 project_object$update(name = name)
}


## ------------------------------------------------
## Method `Project$delete`
## ------------------------------------------------

\dontrun{
 # x is API response when project is requested
 project_object <- Project$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Delete project object
 project_object$delete()
}


## ------------------------------------------------
## Method `Project$list_members`
## ------------------------------------------------

\dontrun{
 # x is API response when project is requested
 project_object <- Project$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # List members in a project
 project_object$list_members()
}


## ------------------------------------------------
## Method `Project$add_member`
## ------------------------------------------------

\dontrun{
 # x is API response when project is requested
 project_object <- Project$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Add member to a project
 project_object$add_member(
      user = "<username_of_a_user_you_want_to_add>",
      permissions = list(write = TRUE, execute = TRUE)
  )
}


## ------------------------------------------------
## Method `Project$remove_member`
## ------------------------------------------------

\dontrun{
 # x is API response when project is requested
 project_object <- Project$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Remove member from a project
 project_object$remove_member(user = user)
}


## ------------------------------------------------
## Method `Project$get_member`
## ------------------------------------------------

\dontrun{
 # x is API response when project is requested
 project_object <- Project$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Get member from a project
 project_object$get_member(user = user)
}


## ------------------------------------------------
## Method `Project$modify_member_permissions`
## ------------------------------------------------

\dontrun{
 # x is API response when project is requested
 project_object <- Project$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Modify member permissions in a project
 project_object$modify_member_permissions(
                  user = user,
                  permission = list(read = TRUE, copy = FALSE)
                  )
}


## ------------------------------------------------
## Method `Project$list_files`
## ------------------------------------------------

\dontrun{
 # x is API response when project is requested
 project_object <- Project$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # List files in a project
 project_object$list_files()
}


## ------------------------------------------------
## Method `Project$create_folder`
## ------------------------------------------------

\dontrun{
 # x is API response when project is requested
 project_object <- Project$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # List files in a project
 project_object$create_folder(name = "new_folder")
}


## ------------------------------------------------
## Method `Project$get_root_folder`
## ------------------------------------------------

\dontrun{
 # x is API response when project is requested
 project_object <- Project$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Get root folder in a project
 project_object$get_root_folder()
}


## ------------------------------------------------
## Method `Project$list_apps`
## ------------------------------------------------

\dontrun{
 # x is API response when project is requested
 project_object <- Project$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # List apps in a project
 project_object$list_apps(query_terms = query_term)
}


## ------------------------------------------------
## Method `Project$create_app`
## ------------------------------------------------

\dontrun{
 # x is API response when project is requested
 project_object <- Project$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Create app in a project
 project_object$create_app(raw = raw)
}


## ------------------------------------------------
## Method `Project$list_tasks`
## ------------------------------------------------

\dontrun{
 # x is API response when project is requested
 project_object <- Project$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # List tasks in a project
 project_object$list_tasks()
}


## ------------------------------------------------
## Method `Project$list_imports`
## ------------------------------------------------

\dontrun{
 # x is API response when project is requested
 project_object <- Project$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # List import jobs in a project
 project_object$list_imports()
}


## ------------------------------------------------
## Method `Project$create_task`
## ------------------------------------------------

\dontrun{
 # x is API response when project is requested
 project_object <- Project$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Create a task in a project
 project_object$create_task(app = app)
}

}
\section{Super class}{
\code{\link[sevenbridges2:Item]{sevenbridges2::Item}} -> \code{Project}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{URL}}{List of URL endpoints for this resource.}

\item{\code{id}}{Project identifier. It consists of project owner's username or
if you are using Enterprise, then the Division name and project's
short name in form of \verb{<owner_username>/<project-short-name>} or
\verb{<division-name>/<project-short-name>}.}

\item{\code{name}}{Project's name.}

\item{\code{billing_group}}{The ID of the billing group for the project.}

\item{\code{description}}{Project's description.}

\item{\code{type}}{Project's type. All projects have type v2.}

\item{\code{tags}}{The list of project tags.}

\item{\code{settings}}{A list which contains detailed project settings.
The following fields are part of the settings object:
\itemize{
\item \code{locked} - If set \code{TRUE}, the project is locked down.
Locking down a project prevents any Seven Bridges team member from
viewing any information about the task.
\item \code{use_interruptible_instances} - Defines the use of
\href{https://docs.sevenbridges.com/docs/about-spot-instances}{spot instances}.
If not included in the request, spot instances are enabled by
default.
\item \code{use_memoization} - Set to \code{FALSE} by default. If set to \code{TRUE}
\href{https://docs.sevenbridges.com/docs/about-memoization}{memoization}
is enabled.
\item \code{use_elastic_disk} - If set to \code{TRUE}
\href{https://docs.sevenbridges.com/page/elastic-disk}{Elastic disk} is
enabled.
\item \code{intermediate_files} (list) - Contains the following subfields:
\itemize{
\item \code{retention} - Specifies that intermediate files should be
retained for a limited amount of time.
The value is always \code{LIMITED}.
\item \code{duration} - Specifies intermediate files retention period
in hours. The minimum value is \code{1}. The maximum value is \code{120}
and the default value is \code{24}.
}
}}

\item{\code{root_folder}}{ID for of the project's root folder.}

\item{\code{created_by}}{Username of the person who created the project.}

\item{\code{created_on}}{Date and time of project creation.}

\item{\code{modified_on}}{Date and time describing when the project was
last modified.}

\item{\code{permissions}}{An object containing the information about user's
permissions within the project.}

\item{\code{category}}{Project's category. By default projects are \code{PRIVATE}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Project-new}{\code{Project$new()}}
\item \href{#method-Project-print}{\code{Project$print()}}
\item \href{#method-Project-detailed_print}{\code{Project$detailed_print()}}
\item \href{#method-Project-reload}{\code{Project$reload()}}
\item \href{#method-Project-update}{\code{Project$update()}}
\item \href{#method-Project-delete}{\code{Project$delete()}}
\item \href{#method-Project-list_members}{\code{Project$list_members()}}
\item \href{#method-Project-add_member}{\code{Project$add_member()}}
\item \href{#method-Project-remove_member}{\code{Project$remove_member()}}
\item \href{#method-Project-get_member}{\code{Project$get_member()}}
\item \href{#method-Project-modify_member_permissions}{\code{Project$modify_member_permissions()}}
\item \href{#method-Project-list_files}{\code{Project$list_files()}}
\item \href{#method-Project-create_folder}{\code{Project$create_folder()}}
\item \href{#method-Project-get_root_folder}{\code{Project$get_root_folder()}}
\item \href{#method-Project-list_apps}{\code{Project$list_apps()}}
\item \href{#method-Project-create_app}{\code{Project$create_app()}}
\item \href{#method-Project-list_tasks}{\code{Project$list_tasks()}}
\item \href{#method-Project-list_imports}{\code{Project$list_imports()}}
\item \href{#method-Project-create_task}{\code{Project$create_task()}}
\item \href{#method-Project-clone}{\code{Project$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Project-new"></a>}}
\if{latex}{\out{\hypertarget{method-Project-new}{}}}
\subsection{Method \code{new()}}{
Create a new Project object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Project$new(res = NA, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{res}}{Response containing Project object information.}

\item{\code{...}}{Other response arguments.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Project-print"></a>}}
\if{latex}{\out{\hypertarget{method-Project-print}{}}}
\subsection{Method \code{print()}}{
Basic print method for Project class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Project$print()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # x is API response when project is requested
 project_object <- Project$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Print project object
 project_object$print()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Project-detailed_print"></a>}}
\if{latex}{\out{\hypertarget{method-Project-detailed_print}{}}}
\subsection{Method \code{detailed_print()}}{
Detailed print method for Project class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Project$detailed_print()}\if{html}{\out{</div>}}
}

\subsection{Details}{
This method allows users to print all the fields from the
Project object more descriptively.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # x is API response when project is requested
 project_object <- Project$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Print project object in detail
 project_object$detailed_print()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Project-reload"></a>}}
\if{latex}{\out{\hypertarget{method-Project-reload}{}}}
\subsection{Method \code{reload()}}{
Reload Project object information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Project$reload(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # x is API response when project is requested
 project_object <- Project$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Reload project object
 project_object$reload()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Project-update"></a>}}
\if{latex}{\out{\hypertarget{method-Project-update}{}}}
\subsection{Method \code{update()}}{
Method that allows you to edit an already existing project.
As a project Admin you can use it to change the \code{name}, \code{settings},
\code{tags} or \verb{billing group} of the project.
Users with write permissions in the project can change the project
\code{description}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Project$update(
  name = NULL,
  description = NULL,
  billing_group = NULL,
  settings = NULL,
  tags = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{New name of the project you are updating.}

\item{\code{description}}{New description of the project you are updating.}

\item{\code{billing_group}}{Billing object or ID of a particular billing
group you want to set to the project.}

\item{\code{settings}}{Contains detailed project settings as explained in
previous methods. Check our
\href{https://docs.sevenbridges.com/reference/edit-a-project}{API documentation}.}

\item{\code{tags}}{The list of project tags you want to update.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'limit', 'offset', 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # x is API response when project is requested
 project_object <- Project$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Change project object name
 project_object$update(name = name)
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Project-delete"></a>}}
\if{latex}{\out{\hypertarget{method-Project-delete}{}}}
\subsection{Method \code{delete()}}{
Method that allows you to delete project from a platform.
It can only be successfully made if you have admin status for the
project. \cr
Please be careful when using this method and note that calling it will
permanently delete the project from the platform.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Project$delete()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # x is API response when project is requested
 project_object <- Project$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Delete project object
 project_object$delete()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Project-list_members"></a>}}
\if{latex}{\out{\hypertarget{method-Project-list_members}{}}}
\subsection{Method \code{list_members()}}{
Method for listing all the project members.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Project$list_members(
  limit = getOption("sevenbridges2")$limit,
  offset = getOption("sevenbridges2")$offset,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{limit}}{The maximum number of collection items to return
for a single request. Minimum value is \code{1}.
The maximum value is \code{100} and the default value is \code{50}.
This is a pagination-specific attribute.}

\item{\code{offset}}{The zero-based starting index in the entire collection
of the first item to return. The default value is \code{0}.
This is a pagination-specific attribute.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Collection}} of \code{\link{Member}} objects.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # x is API response when project is requested
 project_object <- Project$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # List members in a project
 project_object$list_members()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Project-add_member"></a>}}
\if{latex}{\out{\hypertarget{method-Project-add_member}{}}}
\subsection{Method \code{add_member()}}{
Method for adding new members to a specified project.
The call can only be successfully made by a user who has admin
permissions in the project.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Project$add_member(
  user = NULL,
  email = NULL,
  permissions = list(read = TRUE, copy = FALSE, write = FALSE, execute = FALSE, admin =
    FALSE)
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{user}}{The Seven Bridges Platform username of the person
you want to add to the project or object of class Member containing
user's username.}

\item{\code{email}}{The email address of the person you want to add to the
project. This has to be the email address that the person used when
registering for an account on the Seven Bridges Platform.}

\item{\code{permissions}}{List of permissions that will be associated with the
project's member. It can contain fields: \code{read}, \code{copy}, \code{write},
\code{execute} and \code{admin} with logical fields - \code{TRUE} if certain permission
is allowed to the user, or \code{FALSE} if it's not.
Requests to add a project member must include the key permissions.
However, if you do not include a value for some permission, it will be
set to \code{FALSE} by default. The exception to this rule is the \code{read}
permission, which is the default permission on a project. It enables a
user to read project data, including file names, but access file
contents.

Example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{permissions = list(
  read = TRUE,
  copy = TRUE,
  write = FALSE,
  execute = FALSE,
  admin = FALSE
)
}\if{html}{\out{</div>}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Member}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # x is API response when project is requested
 project_object <- Project$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Add member to a project
 project_object$add_member(
      user = "<username_of_a_user_you_want_to_add>",
      permissions = list(write = TRUE, execute = TRUE)
  )
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Project-remove_member"></a>}}
\if{latex}{\out{\hypertarget{method-Project-remove_member}{}}}
\subsection{Method \code{remove_member()}}{
A method for removing members from the project. It can only
be successfully run by a user who has admin privileges in the project.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Project$remove_member(user)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{user}}{The Seven Bridges Platform username of the person
you want to remove from the project or object of class Member containing
user's username.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # x is API response when project is requested
 project_object <- Project$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Remove member from a project
 project_object$remove_member(user = user)
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Project-get_member"></a>}}
\if{latex}{\out{\hypertarget{method-Project-get_member}{}}}
\subsection{Method \code{get_member()}}{
This method returns the information about the member of
the specified project.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Project$get_member(user, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{user}}{The Seven Bridges Platform username of the project member
you want to get information about or object of class Member containing
user's username.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Member}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # x is API response when project is requested
 project_object <- Project$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Get member from a project
 project_object$get_member(user = user)
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Project-modify_member_permissions"></a>}}
\if{latex}{\out{\hypertarget{method-Project-modify_member_permissions}{}}}
\subsection{Method \code{modify_member_permissions()}}{
This method can be used to edit a user's permissions in a
specified  project. It can only be successfully made by a user who
has admin permissions in the project.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Project$modify_member_permissions(
  user = NULL,
  permissions = list(read = TRUE, copy = FALSE, write = FALSE, execute = FALSE, admin =
    FALSE)
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{user}}{The Seven Bridges Platform username of the person
you want to modify permissions on the volume for or object of class
Member containing user's username.}

\item{\code{permissions}}{List of permissions that will be associated with the
project's member. It can contain fields: \code{read}, \code{copy}, \code{write},
\code{execute} and \code{admin} with logical fields - \code{TRUE} if certain permission
is allowed to the user, or \code{FALSE} if it's not.
Requests to add a project member must include the key permissions.
However, if you do not include a value for some permission, it will be
set to \code{FALSE} by default. The exception to this rule is the \code{read}
permission, which is the default permission on a project. It enables a
user to read project data, including file names, but access file
contents.\cr \cr
Example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{permissions = list(read = TRUE, copy = TRUE)
}\if{html}{\out{</div>}}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Permission}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # x is API response when project is requested
 project_object <- Project$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Modify member permissions in a project
 project_object$modify_member_permissions(
                  user = user,
                  permission = list(read = TRUE, copy = FALSE)
                  )
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Project-list_files"></a>}}
\if{latex}{\out{\hypertarget{method-Project-list_files}{}}}
\subsection{Method \code{list_files()}}{
List all project's files and folders.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Project$list_files(
  limit = getOption("sevenbridges2")$limit,
  offset = getOption("sevenbridges2")$offset,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{limit}}{The maximum number of collection items to return
for a single request. Minimum value is \code{1}.
The maximum value is \code{100} and the default value is \code{50}.
This is a pagination-specific attribute.}

\item{\code{offset}}{The zero-based starting index in the entire collection
of the first item to return. The default value is \code{0}.
This is a pagination-specific attribute.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Collection}} of \code{\link{File}} objects.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # x is API response when project is requested
 project_object <- Project$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # List files in a project
 project_object$list_files()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Project-create_folder"></a>}}
\if{latex}{\out{\hypertarget{method-Project-create_folder}{}}}
\subsection{Method \code{create_folder()}}{
Create a new folder under the project's root directory.
Every project on the Seven Bridges Platform is represented
by a root folder which contains all the files associated
with a particular project. You can create first level folders
within this root folder by using this function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Project$create_folder(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Folder name.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{File}} object of type 'FOLDER'.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # x is API response when project is requested
 project_object <- Project$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # List files in a project
 project_object$create_folder(name = "new_folder")
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Project-get_root_folder"></a>}}
\if{latex}{\out{\hypertarget{method-Project-get_root_folder}{}}}
\subsection{Method \code{get_root_folder()}}{
Get project's root folder object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Project$get_root_folder()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{\link{File}} object of type 'FOLDER'.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # x is API response when project is requested
 project_object <- Project$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Get root folder in a project
 project_object$get_root_folder()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Project-list_apps"></a>}}
\if{latex}{\out{\hypertarget{method-Project-list_apps}{}}}
\subsection{Method \code{list_apps()}}{
This call lists all apps in project.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Project$list_apps(
  query_terms = NULL,
  id = NULL,
  limit = getOption("sevenbridges2")$limit,
  offset = getOption("sevenbridges2")$offset,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query_terms}}{Enter one or more search terms to query Project's
apps.}

\item{\code{id}}{Use this parameter to query Project's apps based on their ID.}

\item{\code{limit}}{The maximum number of collection items to return
for a single request. Minimum value is \code{1}.
The maximum value is \code{100} and the default value is \code{50}.
This is a pagination-specific attribute.}

\item{\code{offset}}{The zero-based starting index in the entire collection
of the first item to return. The default value is \code{0}.
This is a pagination-specific attribute.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like other query parameters or 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Collection}} of \code{\link{App}} objects.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # x is API response when project is requested
 project_object <- Project$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # List apps in a project
 project_object$list_apps(query_terms = query_term)
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Project-create_app"></a>}}
\if{latex}{\out{\hypertarget{method-Project-create_app}{}}}
\subsection{Method \code{create_app()}}{
This call creates app in project.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Project$create_app(
  raw = NULL,
  from_path = NULL,
  name,
  raw_format = c("JSON", "YAML")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{raw}}{The body of the request should be a CWL app description saved
as a \code{JSON} or \code{YAML} file. For a template of this description, try
making the call to get raw CWL for an app about an app already in one
of your projects. Shouldn't be used together with \code{from_path}
parameter.}

\item{\code{from_path}}{File containing CWL app description. Shouldn't be used
together with raw parameter.}

\item{\code{name}}{A short name for the app (without any non-alphanumeric
characters or spaces).}

\item{\code{raw_format}}{The type of format used (\code{JSON} or \code{YAML}).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{App}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # x is API response when project is requested
 project_object <- Project$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Create app in a project
 project_object$create_app(raw = raw)
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Project-list_tasks"></a>}}
\if{latex}{\out{\hypertarget{method-Project-list_tasks}{}}}
\subsection{Method \code{list_tasks()}}{
This call lists all tasks from project you can access. \cr
Read more about how to use query parameters properly
\href{https://docs.sevenbridges.com/reference/list-tasks-you-can-access}{here}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Project$list_tasks(
  status = NULL,
  parent = NULL,
  created_from = NULL,
  created_to = NULL,
  started_from = NULL,
  started_to = NULL,
  ended_from = NULL,
  ended_to = NULL,
  order_by = c("created_time", "start_time", "name", "end_time", "created_by"),
  order = c("asc", "desc"),
  origin_id = NULL,
  limit = getOption("sevenbridges2")$limit,
  offset = getOption("sevenbridges2")$offset,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{status}}{You can filter the returned tasks by their status.
Set the value of status to one of the following values:
\itemize{
\item QUEUED
\item DRAFT
\item RUNNING
\item COMPLETED
\item ABORTED
\item FAILED.
}}

\item{\code{parent}}{Provide task ID or task object of the parent task to
return all child tasks from that parent.
A parent task is a task that specifies the criteria by which to
batch its inputs into a series of further sub-tasks, called child tasks.
See the documentation on
\href{https://docs.sevenbridges.com/docs/about-batch-analyses}{batching tasks}
for more details on how to run tasks in batches.}

\item{\code{created_from}}{Enter the starting date string for querying tasks
created on the specified date and onwards.}

\item{\code{created_to}}{Enter the ending date string for querying tasks
created until the specified date. You can use it in combination with
\code{created_from} to specify a time interval.}

\item{\code{started_from}}{Enter the starting date string for querying tasks
started on the specified date and onwards.}

\item{\code{started_to}}{Enter the ending date string for querying tasks
started until the specified date.}

\item{\code{ended_from}}{Enter the starting date string for querying tasks
that ended on a specified date.}

\item{\code{ended_to}}{Enter the ending date string for querying tasks that
ended until a specified date.}

\item{\code{order_by}}{Order returned results by the specified field.
Allowed values: \cr \code{created_time}, \code{start_time}, \code{name}, \code{end_time} and
\code{created_by}. \cr Sort can be done only by one column. The default
value is \code{created_time}.}

\item{\code{order}}{Sort results in ascending or descending order by
specifying \code{asc} or \code{desc}, respectively. Only taken into account if
\code{order_by} is explicitly specified. The default value is \code{asc}.}

\item{\code{origin_id}}{Enter an automation run ID to list all tasks
created from the specified automation run.}

\item{\code{limit}}{The maximum number of collection items to return
for a single request. Minimum value is \code{1}.
The maximum value is \code{100} and the default value is \code{50}.
This is a pagination-specific attribute.}

\item{\code{offset}}{The zero-based starting index in the entire collection
of the first item to return. The default value is \code{0}.
This is a pagination-specific attribute.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Collection}} of \code{\link{Task}} objects.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # x is API response when project is requested
 project_object <- Project$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # List tasks in a project
 project_object$list_tasks()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Project-list_imports"></a>}}
\if{latex}{\out{\hypertarget{method-Project-list_imports}{}}}
\subsection{Method \code{list_imports()}}{
This call lists imports initiated by particular user
into this destination project.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Project$list_imports(
  volume = NULL,
  state = NULL,
  limit = getOption("sevenbridges2")$limit,
  offset = getOption("sevenbridges2")$offset,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{volume}}{Volume id or Volume object. List all imports
from particular volume. Optional.}

\item{\code{state}}{The state of the import job. Possible values are:
\itemize{
\item \code{PENDING}: the import is queued;
\item \code{RUNNING}: the import is running;
\item \code{COMPLETED}: the import has completed successfully;
\item \code{FAILED}: the import has failed.
}
Example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{state = c("RUNNING", "FAILED")
}\if{html}{\out{</div>}}}

\item{\code{limit}}{The maximum number of collection items to return
for a single request. Minimum value is \code{1}.
The maximum value is \code{100} and the default value is \code{50}.
This is a pagination-specific attribute.}

\item{\code{offset}}{The zero-based starting index in the entire collection
of the first item to return. The default value is \code{0}.
This is a pagination-specific attribute.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Collection}} of \code{\link{Import}} objects.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # x is API response when project is requested
 project_object <- Project$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # List import jobs in a project
 project_object$list_imports()
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Project-create_task"></a>}}
\if{latex}{\out{\hypertarget{method-Project-create_task}{}}}
\subsection{Method \code{create_task()}}{
This call creates a new task. You can create either a single
task or a batch task by using the app's default batching, override
batching, or disable batching completely. A parent task is a task that
specifies criteria by which to batch its inputs into a series of further
sub-tasks, called child tasks. the documentation on
\href{https://docs.sevenbridges.com/docs/about-batch-analyses}{batching tasks}
for more details on batching criteria.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Project$create_task(
  app,
  revision = NULL,
  name = NULL,
  description = NULL,
  execution_settings = NULL,
  inputs = NULL,
  output_location = NULL,
  batch = NULL,
  batch_input = NULL,
  batch_by = NULL,
  use_interruptible_instances = NULL,
  action = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{app}}{The ID of an app or an App object you want to run.
Recall that apps are specified by their projects, in the form
\verb{<project_id>/<app_name>}.}

\item{\code{revision}}{The app
\href{https://docs.sevenbridges.com/docs/app-versions}{revision (version)}
number.}

\item{\code{name}}{The name of the task.}

\item{\code{description}}{An optional description of the task.}

\item{\code{execution_settings}}{Named list with detailed task execution
parameters. Detailed task execution parameters:
\itemize{
\item \code{instance_type}: Possible value is the specific instance type,
e.g. \code{"instance_type" = "c4.2xlarge;ebs-gp2;2000"};
\item \code{max_parallel_instances}: Maximum number of instances
running at the same time. Takes any integer value equal to or
greater than 1, e.g. \code{"max_parallel_instances" = 2.};
\item \code{use_memoization}: Set to \code{FALSE} by default. Set to \code{TRUE}
to enable
\href{https://docs.sevenbridges.com/docs/about-memoization}{memoization};
\item \code{use_elastic_disk}: Set to \code{TRUE} to enable
\href{https://docs.sevenbridges.com/page/elastic-disk}{Elastic Disk}.
}

Here is an example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{execution_settings <- list(
  "instance_type" = "c4.2xlarge;ebs-gp2;2000",
  "max_parallel_instances" = 2,
  "use_memoization" = TRUE,
  "use_elastic_disk" = TRUE
  )
}\if{html}{\out{</div>}}}

\item{\code{inputs}}{List of objects. See the section on
\href{https://docs.sevenbridges.com/docs/the-api#section-inputs}{specifying task inputs}
for information on creating task input objects. Here is an example with
various input types:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{inputs <- list(
  "input_file"= "<file_id/file_object>",
  "input_directory" = "<folder_id/folder_object>",
  "input_array_string" = list("<string_elem_1>", "<string_elem_2>"),
  "input_boolean" = TRUE,
  "input_double" = 54.6,
  "input_enum" = "enum_1",
  "input_float" = 11.2,
  "input_integer" = "asdf",
  "input_long" = 4212,
  "input_string" = "test_string",
  "input_record" = list(
    "input_record_field_file" = "<file_id/file_object>",
    "input_record_field_integer" = 42
   )
  )
}\if{html}{\out{</div>}}}

\item{\code{output_location}}{The output location list allows you to
define the exact location where your task outputs will be stored.
The location can either be defined for the entire project using the
main_location parameter, or individually per each output node, by
setting the nodes_override parameter to true and defining individual
output node locations within nodes_location.
See below for more details.
\itemize{
\item \code{main_location} - Defines the output location for all
output nodes in the task. Can be a string path within the project in
which the task is created, for example
\verb{/Analysis/<task_id>_<task_name>/}
or a path on an attached volume, such as
\verb{volumes://volume_name/<project_id>/html}.
Parts of the path enclosed in angle brackets <> are tokens that are
dynamically replaced with corresponding values during task
execution.
\item \code{main_location_alias}: The string location (path) in the
project that will point to the actual location where the outputs are
stored. Used if main_location is defined as a volume path (starting
with volumes://), to provide an easy way of accessing output data
directly from project files.
\item \code{nodes_override}: Enables defining of output locations
for output nodes individually through nodes_location (see below).
Set to \code{TRUE} to be able to define individual locations per output
node. Default: \code{FALSE}.
Even if nodes_override is set to \code{TRUE}, it is not necessary to
define output locations for each of the output nodes individually.
Data from those output nodes that don't have their locations
explicitly defined through nodes_location is either placed in
main_location (if defined) or at the project files root if a main
output location is not defined for the task.
\item \code{nodes_location}: List of output paths for individual
task output nodes in the following format for each output node: \cr
\verb{<output-node-id> = list(} \cr
\verb{"output_location" = "<output-path>",} \cr
\code{"output_location_alias" = "<alias-path>"} \cr
\verb{)} \cr
Example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{b64html = list(
 "output_location" = "volumes://outputs/tasks/mar-19",
 "output_location_alias" = "/rfranklin/tasks/picard"
)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{ In the example above, b64html is the ID of the output node for which
 you want to define the output location, while the parameters are
 defined as follows:
}\if{html}{\out{</div>}}

\itemize{
\item \code{output_location} - Can be a path within the project in which
the task is created, for example
\verb{/Analysis/<task_id>_<task_name>/}
or a path on an attached volume, such as
\verb{volumes://volume_name/<project_id>/html}. Also accepts tokens.
\item \code{output_location_alias} - The location (path) in the project
that will point to the exact location where the output is stored.
Used if output_location is defined as a volume path
(starting with volumes://).
}
}}

\item{\code{batch}}{This is set to \code{FALSE} by default. Set to \code{TRUE} to
create a batch task and specify the \code{batch_input} and \code{batch-by}
criteria as described below.}

\item{\code{batch_input}}{The ID of the input on which you wish to batch.
You would typically batch on the input consisting of a list of files.
If this parameter is omitted, the default batching criteria defined for
the app will be used.}

\item{\code{batch_by}}{Batching criteria in form of list. For example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{batch_by = list(
  type = "CRITERIA",
  criteria = list("metadata.condition")
)
}\if{html}{\out{</div>}}}

\item{\code{use_interruptible_instances}}{This field can be \code{TRUE} or \code{FALSE}.
Set this field to \code{TRUE} to allow the use of
\href{https://docs.sevenbridges.com/docs/about-spot-instances}{spot instances}.}

\item{\code{action}}{If set to \code{run}, the task will be run immediately upon
creation.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Task}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 # x is API response when project is requested
 project_object <- Project$new(
                    res = x,
                    href = x$href,
                    auth = auth,
                    response = attr(x, "response")
                   )

 # Create a task in a project
 project_object$create_task(app = app)
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Project-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Project-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Project$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
