% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-apps.R
\name{Apps}
\alias{Apps}
\title{R6 Class representing apps endpoint}
\description{
R6 Class representing apps resource endpoint.
}
\examples{

## ------------------------------------------------
## Method `Apps$query`
## ------------------------------------------------

\dontrun{
 apps_object <- Apps$new(
   auth = auth
 )

 # List public apps
 apps_object$query(visibility = "public")
}


## ------------------------------------------------
## Method `Apps$get`
## ------------------------------------------------

\dontrun{
 apps_object <- Apps$new(
   auth = auth
 )

 # Get app object
 apps_object$get(id = "<some_id>")
}


## ------------------------------------------------
## Method `Apps$copy`
## ------------------------------------------------

\dontrun{
 apps_object <- Apps$new(
   auth = auth
 )
 # Copy app object to a project
 apps_object$copy(app = app, project = project)
}


## ------------------------------------------------
## Method `Apps$create`
## ------------------------------------------------

\dontrun{
 apps_object <- Apps$new(
   auth = auth
 )

 # Create new app object
 apps_object$create(
  raw = raw,
  project = project,
  name = name,
  raw_format = "YAML"
 )
}

}
\section{Super class}{
\code{\link[sevenbridges2:Resource]{sevenbridges2::Resource}} -> \code{Apps}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{URL}}{List of URL endpoints for this resource.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Apps-new}{\code{Apps$new()}}
\item \href{#method-Apps-query}{\code{Apps$query()}}
\item \href{#method-Apps-get}{\code{Apps$get()}}
\item \href{#method-Apps-copy}{\code{Apps$copy()}}
\item \href{#method-Apps-create}{\code{Apps$create()}}
\item \href{#method-Apps-clone}{\code{Apps$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="sevenbridges2" data-topic="Resource" data-id="delete"><a href='../../sevenbridges2/html/Resource.html#method-Resource-delete'><code>sevenbridges2::Resource$delete()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Apps-new"></a>}}
\if{latex}{\out{\hypertarget{method-Apps-new}{}}}
\subsection{Method \code{new()}}{
Create new Apps resource object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Apps$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Other response arguments.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Apps-query"></a>}}
\if{latex}{\out{\hypertarget{method-Apps-query}{}}}
\subsection{Method \code{query()}}{
This call lists all the apps available to you.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Apps$query(
  project = NULL,
  visibility = c("private", "public"),
  query_terms = NULL,
  id = NULL,
  limit = getOption("sevenbridges2")$limit,
  offset = getOption("sevenbridges2")$offset,
  fields = "!raw",
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{project}}{Project ID string in the form
\verb{<project_owner>/<project_short_name>} or \cr
\verb{<division_name>/<project_short_name>} or Project object, \cr
to restrict the results to apps from that project only.}

\item{\code{visibility}}{Set this to \code{public} to see all public apps on
the Seven Bridges Platform.}

\item{\code{query_terms}}{Enter one or more search terms to query apps.
Read more about how to use the query_terms parameter in our
\href{https://docs.sevenbridges.com/reference/list-all-apps-available-to-you#query-apps}{API documentation}.}

\item{\code{id}}{Use this parameter to query apps based on their ID.}

\item{\code{limit}}{The maximum number of collection items to return
for a single request. Minimum value is \code{1}.
The maximum value is \code{100} and the default value is \code{50}.
This is a pagination-specific attribute.}

\item{\code{offset}}{The zero-based starting index in the entire collection
of the first item to return. The default value is \code{0}.
This is a pagination-specific attribute.}

\item{\code{fields}}{Selector specifying a subset of fields to include in the
response. For querying apps it is set to return all fields except 'raw'
which stores CWL in form of a list. Please, be careful when setting to
return all fields, since the execution of this API request could be
time-consuming.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{Collection}} containing \code{\link{App}} objects.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 apps_object <- Apps$new(
   auth = auth
 )

 # List public apps
 apps_object$query(visibility = "public")
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Apps-get"></a>}}
\if{latex}{\out{\hypertarget{method-Apps-get}{}}}
\subsection{Method \code{get()}}{
This call returns information about the specified app.
The app should be one in a project that you can access;
this could be an app that has been uploaded to the Seven Bridges
Platform by a project member, or a publicly available app that has
been copied to the project. \cr
More about this operation you can find in our
\href{https://docs.sevenbridges.com/reference/get-details-of-an-app}{API documentation}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Apps$get(id, revision = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{The full \verb{<project_id>/<app_short_name>}
path for this API call is known as App ID. You can also get the App ID
for an app by making the call to list all apps available to you.}

\item{\code{revision}}{The number of the app revision you want to get.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{App}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 apps_object <- Apps$new(
   auth = auth
 )

 # Get app object
 apps_object$get(id = "<some_id>")
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Apps-copy"></a>}}
\if{latex}{\out{\hypertarget{method-Apps-copy}{}}}
\subsection{Method \code{copy()}}{
This call copies the specified app to the specified project.
The app should be one in a project that you can access; this could be an
app that has been uploaded to the Seven Bridges Platform by a project
member, or a publicly available app that has been copied to the project.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Apps$copy(
  app,
  project,
  name = NULL,
  strategy = c("clone", "direct", "clone_direct", "transient"),
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{app}}{App object or the short name of the app you are copying.
Optionally, to copy a specific revision of the app, use the
\verb{<app_short_name>/<revision_number>} format, for example
\code{rfranklin/my-project/bamtools-index-2-4-0/1}}

\item{\code{project}}{The Project object or project ID you want to copy the app
to.}

\item{\code{name}}{The new name the app will have in the target project.
If its name will not change, omit this key.}

\item{\code{strategy}}{The method for copying the app. Can be one of:
\itemize{
\item \code{clone} : copy all revisions; get updates from the same app
as the copied app (default);
\item \code{direct}: copy latest revision; get updates from the copied app;
\item \code{clone_direct}: copy all revisions; get updates from the
copied app;
\item \code{transient}: copy latest revision; get updates from the same
app as the copied app.
}
Read more about the strategies
\href{https://docs.sevenbridges.com/reference/copy-an-app#methods-for-copying-an-app}{here}.}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Copied \code{\link{App}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 apps_object <- Apps$new(
   auth = auth
 )
 # Copy app object to a project
 apps_object$copy(app = app, project = project)
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Apps-create"></a>}}
\if{latex}{\out{\hypertarget{method-Apps-create}{}}}
\subsection{Method \code{create()}}{
This call allows you to add an app using raw CWL.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Apps$create(
  raw = NULL,
  from_path = NULL,
  project,
  name,
  raw_format = c("JSON", "YAML"),
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{raw}}{The body of the request should be a CWL app description saved
as a \code{JSON} or \code{YAML} file. For a template of this description, try
making the call to get raw CWL for an app about an app already in one of
your projects. Shouldn't be used together with \code{from_path} parameter.}

\item{\code{from_path}}{File containing CWL app description. Shouldn't be used
together with raw parameter.}

\item{\code{project}}{String project ID or Project object in which you want to
store the app.}

\item{\code{name}}{A short name for the app (without any non-alphanumeric
characters or spaces)}

\item{\code{raw_format}}{The type of format used (\code{JSON} or \code{YAML}).}

\item{\code{...}}{Other arguments that can be passed to core \code{api()} function
like 'fields', etc.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link{App}} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
 apps_object <- Apps$new(
   auth = auth
 )

 # Create new app object
 apps_object$create(
  raw = raw,
  project = project,
  name = name,
  raw_format = "YAML"
 )
}

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Apps-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Apps-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Apps$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
