% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_variables.R
\name{summaryNetDisplacement}
\alias{summaryNetDisplacement}
\title{Calculate net displacement}
\usage{
summaryNetDisplacement(list, summary.df = NA)
}
\arguments{
\item{list}{A list of data frames, each of which has a column representing dx
and dy.}

\item{summary.df}{The data frame object within which you are storing path
summary variables. The default is NA if you do not currently have a summary
data frame object started. When set to NA the function will create a new
summary data frame. When an object is provided, the function will merge the
summary data frame with the new data.}
}
\value{
A named vector of numbers where each number corresponds to the net
  displacement of a movement path. The numbers are ordered and named as they
  are in the data frames list.
}
\description{
Calculate the net displacement for a path taken by an organism
}
\details{
Net displacement is the distance between the start of a path and the end of a
path. This function calculates the net displacement for a path recorded from
the servosphere.
}
