% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_analytics.R
\name{sst_sa_domain_top_pages}
\alias{sst_sa_domain_top_pages}
\title{Domain top pages}
\usage{
sst_sa_domain_top_pages(
  api_token,
  domain,
  se,
  sort = NULL,
  filters = NULL,
  page = 1,
  size = 100,
  return_method = "list"
)
}
\arguments{
\item{api_token}{(required) Serpstat API token from
\href{https://serpstat.com/users/profile/}{your profile}.}

\item{domain}{(required) Domain to get data for.}

\item{se}{(required) Search engine alias (db_name) returned by
\code{\link{sst_sa_database_info}}.}

\item{sort}{(optional) A field to sort the response. See Sorting for more
details.}

\item{filters}{(optional) A list of filtering options. See Filtering for more
details.}

\item{page}{(optional) Response page number if there are many pages in response.}

\item{size}{(optional) Response page size.}

\item{return_method}{(optional) Accepted values are 'list' (default) to
return data object as list or 'df' to return data object as data.frame.}
}
\value{
Returns domain top pages with their metrics.
}
\description{
Returns the number of domain pages with the biggest potential traffic,
  number of keywords, and Facebook shares.
}
\section{API docs}{

 Check all the values for request and response fields \href{https://serpstat.com/api/588-domain-top-urls-v4-serpstatdomainproceduregettopurls/}{here}.
}

\section{API credits consumption}{
 1 per returned page.
}

\section{Sorting}{

  You can sort the response using \code{sort} argument. It must be a list
  with a single named element. The name of the element must match one of
  parameters in response. The value of the element must be \code{asc} for
  ascending order and \code{desc} for descending order. For example,
  \code{sort = list(ads = 'desc')} would sort the response by \code{ads}
  parameter in descending order.
}

\section{Filtering}{

  To filter the results you can use \code{filters} argument. It must be a
  list of named elements. The name of the element must match one of the
  filtering parameters. See API docs for more details. For example,
  \code{filters = list(queries_from = 0, queries_to = 10)} would narrow
  the results to include only the keywords that have a search volume
  between 0 and 10.
}

\examples{
\dontrun{
api_token <- Sys.getenv('SERPSTAT_API_TOKEN')
sst_sa_domain_top_pages(
  api_token     = api_token,
  domain        = 'serpstat.com',
  se            = 'g_us',
  sort          = list(organic_keywords = 'desc'),
  filters       = list(url_contain = 'blog'),
  page          = 2,
  size          = 50,
  return_method = 'df'
)$data
}
}
