% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalcBYprobs.R
\name{CalcBYprobs}
\alias{CalcBYprobs}
\title{Birth year probabilities}
\usage{
CalcBYprobs(Pedigree = NULL, LifeHistData = NULL, AgePrior = NULL)
}
\arguments{
\item{Pedigree}{dataframe with columns id-dam-sire.}

\item{LifeHistData}{dataframe with 3 columns (optionally 5):
 \describe{
 \item{ID}{max. 30 characters long}
 \item{Sex}{1 = female, 2 = male, 3 = unknown, 4 = hermaphrodite,
           other numbers or NA = unknown}
\item{BirthYear }{birth or hatching year, integer, with missing values as NA
  or any negative value.}
\item{BY.min}{minimum birth year, only used if BirthYear is missing}
\item{BY.max}{maximum birth year, only used if BirthYear is missing} }
If the species has multiple generations per year, use an integer coding such
that the candidate parents' `Birth year' is at least one smaller than their
putative offspring's. Column names are ignored, so ensure column order is ID
- sex - birth year (- BY.min - BY.max). Individuals do not need to be in the
same order as in `Pedigree', nor do all individuals in the pedigree need to
be included.}

\item{AgePrior}{a matrix with probability ratios for individuals with age
difference A to have relationship R, as generated by
\code{\link{MakeAgePrior}}. If \code{NULL}, \code{\link{MakeAgePrior}} is
called using its default values.}
}
\value{
A matrix with for each individual (rows) in the pedigree that has a missing
  birth year in \code{LifeHistData}, or that is not included in
  \code{LifeHistData}, the probability that it is born in \code{y} (columns).
  Probabilities are rounded to 3 decimal points and may therefore not sum
  exactly to 1.
}
\description{
Estimate the probability that an individual with unknown birth
  year is born in year \code{y}, based on the (estimated) birth years of its
  parents and offspring and the age distribution of other parent-offspring
  pairs.
}
\details{
This function assists in estimating birth years of individuals for
  which these are unknown, provided they have at least one parent or one
  offspring in the pedigree. It is not a substitute for field-based estimates
  of age, only a method to summarise the pedigree + birth year based
  information.

  No distinction is made between genotyped and non-genotyped or dummy
  individuals.
}
\section{WARNING}{

 Any errors in the pedigree or lifehistory data will cause errors in the
 birth year probabilities of their parents and offspring, and putatively also
 of more distant ancestors and descendants. If the ageprior is based on the
 same erroneous pedigree and lifehistory data, all birth year probabilities
 will be affected.
}

\examples{
BYprobs <- CalcBYprobs(Pedigree = SeqOUT_griffin$Pedigree,
                       LifeHistData = SeqOUT_griffin$LifeHist)
\dontrun{
# heatmap
lattice::levelplot(t(BYprobs), aspect="fill", col.regions=hcl.colors)
}

}
\seealso{
\code{\link{MakeAgePrior}} to estimate effect of age on
  relationships.
}
