% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permute.R
\name{fix_cor}
\alias{fix_cor}
\title{Fixes an invalid target correlation.}
\usage{
fix_cor(design_perm, target_cor, num_steps = 51)
}
\arguments{
\item{design_perm}{A numeric design matrix whose rows are to be permuted
(thus controlling the amount by which they are correlated with the
surrogate variables). The rows index the samples and the columns index
the variables. The intercept should \emph{not} be included
(though see Section "Unestimable Components").}

\item{target_cor}{A numeric matrix of target correlations between the
variables in \code{design_perm} and the surrogate variables. The
rows index the observed covariates and the columns index the surrogate
variables. That is, \code{target_cor[i, j]} specifies the target
correlation between the \code{i}th column of \code{design_perm} and the
\code{j}th surrogate variable. The surrogate variables are estimated
either using factor analysis or surrogate variable analysis (see the
parameter \code{use_sva}).
The number of columns in \code{target_cor} specifies the number of
surrogate variables. Set \code{target_cor} to \code{NULL} to indicate
that \code{design_perm} and the surrogate variables are independent.}

\item{num_steps}{The number of steps between 0 and 1 to take in the
grid search for the shrinkage factor. The step-size would be
\code{1 / (num_steps - 1)}.}
}
\value{
A matrix of correlations the same dimension as \code{target_cor}.
   Actually, the returned matrix is \code{a * target_cor}, where \code{a}
   was determined to make the overall correlation matrix positive
   semi-definite.
}
\description{
Shrinks the target correlation using a uniform scaling factor so that
the overall correlation matrix is positive semi-definite.
}
\details{
Let \eqn{W} = \code{cor(design_perm)}. Let \eqn{R} = \code{target_cor}.
Then the overall correlation matrix is:
\deqn{ \left(
\begin{array}{cc}
W  & R\\
R' & I_K
\end{array}
\right).
}
This function applies a multiplicative scaling factor to \eqn{R} until
the above matrix is positive semi-definite. That is, it finds \eqn{a}
between 0 and 1 such that
\deqn{ \left(
\begin{array}{cc}
W  & aR\\
aR' & I_K
\end{array}
\right)
}
is positive semi-definite.
}
\examples{
n <- 10
design_perm <- matrix(rep(c(0, 1), length.out = n))
target_cor <- matrix(seq(1, 0, length.out = 10), nrow = 1)
new_cor <- seqgendiff:::fix_cor(design_perm = design_perm, target_cor = target_cor)
new_cor / target_cor

## In the case of one observed covariate, the requirement is just that
## the sum of squared correlations is less than or equal to one.
sum(target_cor ^ 2)
sum(new_cor ^ 2)
}
\author{
David Gerard
}
