% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqHMM-deprecated.R
\docType{package}
\name{seqHMM-deprecated}
\alias{seqHMM-deprecated}
\alias{fit_hmm}
\alias{fit_mhmm}
\alias{trim_hmm}
\title{Deprecated function(s) in the seqHMM package}
\usage{
fit_hmm(
  model,
  em_step = TRUE,
  global_step = FALSE,
  local_step = FALSE,
  control_em = list(),
  control_global = list(),
  control_local = list(),
  lb,
  ub,
  threads = 1,
  log_space = FALSE,
  ...
)

fit_mhmm(
  model,
  em_step = TRUE,
  global_step = FALSE,
  local_step = FALSE,
  control_em = list(),
  control_global = list(),
  control_local = list(),
  lb,
  ub,
  threads = 1,
  log_space = FALSE,
  ...
)

trim_hmm(
  model,
  maxit = 0,
  return_loglik = FALSE,
  zerotol = 1e-08,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{model}{An object of class \code{hmm} or \code{mhmm}.}

\item{em_step}{Logical. Whether or not to use the EM algorithm at the start
of the parameter estimation. The default is \code{TRUE}.}

\item{global_step}{Logical. Whether or not to use global optimization via
\code{\link{nloptr}} (possibly after the EM step). The default is \code{FALSE}.}

\item{local_step}{Logical. Whether or not to use local optimization via
\code{\link{nloptr}} (possibly after the EM and/or global steps). The default is \code{FALSE}.}

\item{control_em}{Optional list of control parameters for the EM algorithm.
Possible arguments are \describe{
\item{maxeval}{The maximum number of iterations, the default is 1000.
Note that iteration counter starts with -1 so with \code{maxeval=1} you get already two iterations.
This is for backward compatibility reasons.}
\item{print_level}{The level of printing. Possible values are 0
(prints nothing), 1 (prints information at the start and the end of the algorithm),
2 (prints at every iteration),
and for mixture models 3 (print also during optimization of coefficients).}
\item{reltol}{Relative tolerance for convergence defined as
\eqn{(logLik_new - logLik_old)/(abs(logLik_old) + 0.1)}.
The default is 1e-10.}
\item{restart}{A list containing options for possible EM restarts with the
  following components:
\describe{
\item{times}{Number of restarts of the EM algorithm using random initial values. The default is 0, i.e. no restarts. }
\item{transition}{Logical. Should the original transition probabilities be varied? The default is \code{TRUE}. }
\item{emission}{Logical. Should the original emission probabilities be varied? The default is \code{TRUE}. }
\item{sd}{Standard deviation for \code{rnorm} used in randomization. The default is 0.25.}
\item{maxeval}{Maximum number of iterations, the default is \code{control_em$maxeval}}
\item{print_level}{Level of printing in restarted EM steps. The default is \code{control_em$print_level}. }
\item{reltol}{Relative tolerance for convergence at restarted EM steps. The default is \code{control_em$reltol}.
If the relative change of the final model of the restart phase is larger than the tolerance
for the original EM phase, the final model is re-estimated with the original \code{reltol}
and \code{maxeval} at the end of the EM step.}
\item{n_optimum}{Save the log-likelihood values of the \code{n_optimum} best
models (from all estimated models including the the first EM run.).
The default is \code{min(times + 1, 25)}.}
\item{use_original}{If \code{TRUE}. Use the initial values of the input model as starting
points for the permutations. Otherwise permute the results of the first EM run.}
}
}
}}

\item{control_global}{Optional list of additional arguments for
  \code{\link{nloptr}} argument \code{opts}. The default values are
  \describe{
   \item{algorithm}{\code{"NLOPT_GD_MLSL_LDS"}}
   \item{local_opts}{\code{list(algorithm = "NLOPT_LD_LBFGS", ftol_rel = 1e-6, xtol_rel = 1e-4)}}
   \item{maxeval}{\code{10000} (maximum number of iterations in global optimization algorithm.)}
   \item{maxtime}{\code{60} (maximum time for global optimization. Set to 0 for unlimited time.)}
}}

\item{control_local}{Optional list of additional arguments for
\code{\link{nloptr}} argument \code{opts}. The default values are
\describe{
 \item{algorithm}{\code{"NLOPT_LD_LBFGS"}}
 \item{ftol_rel}{\code{1e-10}}
 \item{xtol_rel}{\code{1e-8}}
 \item{maxeval}{\code{10000} (maximum number of iterations)}
}}

\item{lb, ub}{Lower and upper bounds for parameters in Softmax parameterization.
The default interval is \eqn{[pmin(-25, 2*initialvalues), pmax(25, 2*initialvalues)]},
except for gamma coefficients,
where the scale of covariates is taken into account.
Note that it might still be a good idea to scale covariates around unit scale.
Bounds are used only in the global optimization step.}

\item{threads}{Number of threads to use in parallel computing. The default is 1.}

\item{log_space}{Make computations using log-space instead of scaling for greater
numerical stability at a cost of decreased computational performance. The default is \code{FALSE}.}

\item{...}{Additional arguments to \code{nloptr}.}

\item{maxit}{Number of iterations. After zeroing small values, the model is
refitted, and this is repeated until there is nothing to trim or \code{maxit}
iterations are done.}

\item{return_loglik}{Return the log-likelihood of the trimmed model together with
the model object. The default is \code{FALSE}.}

\item{zerotol}{Values smaller than this are trimmed to zero.}

\item{verbose}{Print results of trimming. The default is \code{TRUE}.}
}
\description{
These functions are provided for compatibility with older version of
the seqHMM package.  They will be eventually completely
removed.
}
