% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.effects.R
\name{stderrs}
\alias{stderrs}
\alias{stderr.bb}
\alias{stderr.bc}
\alias{stderr.cb}
\alias{stderr.cc}
\title{Functions to calculate standard errors of the direct, indirect and total effects using the delta method.}
\usage{
stderr.bb(Rho, betas, thetas, sigma.pars, x.med, x.out, alt.decomposition,
  exp.value, control.value)

stderr.bc(Rho, betas, thetas, sigma.pars, x.med, x.out, alt.decomposition,
  exp.value, control.value)

stderr.cb(Rho, betas, thetas, sigma.eta, sigma.pars, x.med, x.out,
  alt.decomposition, exp.value, control.value)

stderr.cc(Rho, betas, thetas, sigma.pars, x.med, x.out, alt.decomposition,
  exp.value, control.value)
}
\arguments{
\item{Rho}{The sensitivity parameter vector.}

\item{betas}{List of mediator regression parameters}

\item{thetas}{List of outcome regression parameters}

\item{sigma.pars}{List of covariance matrices for the mediator and outcome regression parameters}

\item{x.med}{Mediator covariate matrix for which to calculate standard errors}

\item{x.out}{Outcome covariate matrix for which to calculate standard errors}

\item{alt.decomposition}{logical indicating whether or not alternative definitions of the direct and indirect effects should be used.}

\item{exp.value}{value of the exposure variable used as the exposure condition.}

\item{control.value}{value of the exposure variable used as the control (unexposed) condition.}

\item{sigma.eta}{For a continuous mediator and binary outcome, matrix with the estimated residual standard deviation for the mediator model over the range of \code{Rho}.}
}
\description{
Functions used to calculate standard errors of the direct, indirect and total effects using the delta method. Called by \code{\link{calc.effects}}.
The functions are named according to the convention \code{stderr."mediator model type""outcome model type"} where \code{b}
stands for binary probit regression and \code{c} stands for linear regression.
}
