% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensi_plot.sensiIntra.sensiTree.R
\name{sensi_plot.sensiTree.TraitEvol}
\alias{sensi_plot.sensiTree.TraitEvol}
\title{Graphical diagnostics for class 'sensiTree.TraitEvol'}
\usage{
\method{sensi_plot}{sensiTree.TraitEvol}(x, graphs = "all", ...)
}
\arguments{
\item{x}{output from \code{tree_fitDiscrete} or \code{tree_fitContinuous}}

\item{graphs}{choose which graph should be printed in the output ("all", "q12", "q21", "aic" or" "optpar")}

\item{...}{further arguments to methods}
}
\description{
\code{sensi_plot.sensiTree.TraitEvol} Plot results from \code{tree_discrete} and \code{tree_continuous}.
}
\seealso{
\code{\link[ggplot2]{ggplot}}, \code{\link[sensiPhy]{tree_discrete}}
\code{\link[sensiPhy]{tree_continuous}}

The following graphs are printed. 

\strong{Graph aicc:} Distribution of estimated AICc-values across each tree.
Red vertical line represents the mean value among all estimates. 
Blue vertical line represents the median value among all estimates. 

\strong{Graph optpar:} Distribution of estimated values for optimisation parameter specified using 'transform' (if applicable)
Red vertical line represents the mean value among all estimates. 
Blue vertical line represents the median value among all estimates. 

Additionally, only for \code{tree_discrete} the function creates the following graphs. 

\strong{Graph q12:} Distribution of estimated parameter values for transition rates q12 for each tree.
Red vertical line represents the mean value among all estimates. 
Blue vertical line represents the median value among all estimates. 

\strong{Graph q21:} Distribution of estimated parameter values for transition rates q21 for each tree.
Red vertical line represents the mean value among all estimates. 
Blue vertical line represents the median value among all estimates. 

While only for \code{tree_continuous} the function creates the following graphs. 

\strong{Graph sigsq:} Distribution of estimated parameter values for rate of evolution sigsq for each tree.
Red vertical line represents the mean value among all estimates. 
Blue vertical line represents the median value among all estimates. 

\strong{Graph z0:} Distribution of estimated parameter values for z0 for each tree.
Red vertical line represents the mean value among all estimates. 
Blue vertical line represents the median value among all estimates.
}
\author{
Gijsbert Werner
}
