% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensi_plot.sensiINTER_Clade.R
\name{sensi_plot.sensiTree_Clade}
\alias{sensi_plot.sensiTree_Clade}
\title{Graphical diagnostics for class 'sensiTree_Clade'}
\usage{
\method{sensi_plot}{sensiTree_Clade}(x, clade = NULL, graphs = "all", ...)
}
\arguments{
\item{x}{output from \code{tree_clade_phylm} or \code{tree_clade_phyglm}}

\item{clade}{The name of the clade to be evaluated (see details)}

\item{graphs}{Choose which graph should be printed on the output ("all", 1 or 2). Defaults to "all".}

\item{...}{further arguments to methods.}
}
\description{
Plot results from \code{tree_clade_phylm} and \code{tree_clade_phyglm}
}
\details{
For 'x' from tree_clade_phylm or tree_clade_phyglm:

\strong{Graph 1:} Estimated slopes after clade removal (reduced data) across multiple trees.
 Small dots represent estimates reruns between phylogenetic trees while larger 
 dots represents the average estimate between all trees for each clade. 
 The solid black line represents the average slope estimate among trees
 using the full dataset.

\strong{Graph 2:} The effect of clade removal on slope estimate across all individual 
phylogenetic trees for each clade analyzed. The black line indicates estimates 
with the full dataset while the red line represent estimates without the focal
 clade (reduced data) across different trees. The blue dots represent null expectation
 estimates after removing the same number of species of the focal clade,
 with dots falling outside the red line area indicating a larger than expected 
 absolute effect.
}
\seealso{
\code{\link[sensiPhy]{tree_clade_phylm}}
}
\author{
Gustavo Paterno, Caterina Penone
}
